% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_region_methylation_transcript_cors.R
\name{calculateRegionMethylationTranscriptCors}
\alias{calculateRegionMethylationTranscriptCors}
\title{Calculate the correlation values between the methylation of genomic regions and the expression of associated transcripts}
\usage{
calculateRegionMethylationTranscriptCors(
  meth_rse,
  assay = 1,
  transcript_expression_table,
  samples_subset = NULL,
  genomic_regions,
  genomic_region_names = NULL,
  genomic_region_transcripts = NULL,
  genomic_region_methylation = NULL,
  cor_method = "pearson",
  p_adjust_method = "BH",
  region_methylation_summary_function = colMeans,
  BPPARAM = BiocParallel::SerialParam(),
  ...
)
}
\arguments{
\item{meth_rse}{A RangedSummarizedExperiment with methylation values for CpG sites which will be used to calculate methylation values for genomic_regions.
There must be at least 3 samples in common between meth_rse and transcript_expression_table.}

\item{assay}{The assay from meth_rse to extract values from. Should be either an index or the name of an assay. Default is the first assay.}

\item{transcript_expression_table}{A table with the expression values for different transcripts in different samples.
Row names should give be the transcript name and column names should be the name of samples.}

\item{samples_subset}{Optional sample names used to subset meth_rse and transcript_expression_table.
Provided samples must be found in both meth_rse and transcript_expression_table.
Default is to use all samples in meth_rse and transcript_expression_table.}

\item{genomic_regions}{A GRanges object.}

\item{genomic_region_names}{A character vector of unique names to assign genomic_regions in the output table.
Defaults to \code{names(genomic_regions)} if present or otherwise converts regions to character strings (e.g. "chr:1000-2000") to use as names.}

\item{genomic_region_transcripts}{Names of transcripts associated with each region in genomic_regions.
If not provided, attempts to use genomic_regions$transcript_id. All transcripts must be present in transcript_expression_table.}

\item{genomic_region_methylation}{Optional preprovided table with methylation values for genomic_regions
such as created using summarizeRegionMethylation(). Table will be created if it is not provided which will increase running time.
Row names should match genomic_region_names and column names should match those of transcript_expression_table}

\item{cor_method}{A character string indicating which correlation coefficient is to be computed.
One of either "pearson" or "spearman" or their abbreviations.}

\item{p_adjust_method}{Method used to adjust p-values. Same as the methods from p.adjust.methods. Default is Benjamini-Hochberg.}

\item{region_methylation_summary_function}{A function that summarizes column values. Default is colMeans.}

\item{BPPARAM}{A BiocParallelParam object for parallel processing. Defaults to \code{BiocParallel::SerialParam()}.}

\item{...}{Additional arguments to be passed to summary_function.}
}
\value{
A data.frame with the correlation values between the methylation of genomic regions and expression of transcripts associated with them
}
\description{
Calculate the correlation values between the methylation of genomic regions and the expression of associated transcripts
}
\examples{

# Load TUBB6 TMRs, RangedSummarizedExperiment with methylation values for CpGs around TUBB6 TSS and TUBB6 transcript counts
data(tubb6_tmrs, package = "methodical")
data(tubb6_meth_rse, package = "methodical")
tubb6_meth_rse <- eval(tubb6_meth_rse)
data(tubb6_transcript_counts, package = "methodical")

# Calculate correlation values between TMRs identified for TUBB6 and transcript expression
tubb6_tmrs_transcript_cors <- methodical::calculateRegionMethylationTranscriptCors(
  meth_rse = tubb6_meth_rse, transcript_expression_table = tubb6_transcript_counts,
  genomic_regions = tubb6_tmrs, genomic_region_names = tubb6_tmrs$tmr_name)
tubb6_tmrs_transcript_cors
 
}
