% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kallisto_quantify.R
\name{kallistoIndex}
\alias{kallistoIndex}
\title{Create an index file for running Kallisto}
\usage{
kallistoIndex(
  path_to_kallisto,
  transcripts_fasta,
  index_name = "kallisto_index.idx"
)
}
\arguments{
\item{path_to_kallisto}{Path to kallisto executable}

\item{transcripts_fasta}{Path to a fasta file for the transcripts to be quantified.}

\item{index_name}{Name to give the created index file. Default is "kallisto_index.idx".}
}
\value{
Invisibly returns TRUE.
}
\description{
Create an index file for running Kallisto
}
\examples{
\dontrun{
# Download transcripts FASTA from Gencode
download.file("https://ftp.ebi.ac.uk/pub/databases/gencode/Gencode_human/release_44/gencode.v44.transcripts.fa.gz")

# Locate the kallisto executable (provided that it is on the path)
kallisto_path <- system2("which", args = "kallisto", stdout = TRUE)

# Create transcripts index for use with Kallisto
methodical::kallistoIndex(kallisto_path, transcripts_fasta = "gencode.v44.transcripts.fa.gz")
}
}
