% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methylInheritanceMethods.R
\name{loadAllRDSResults}
\alias{loadAllRDSResults}
\title{Load all RDS files created by the permutation  and observation
analysis}
\usage{
loadAllRDSResults(
  analysisResultsDir,
  permutationResultsDir,
  doingSites = TRUE,
  doingTiles = FALSE,
  maxID = NA
)
}
\arguments{
\item{analysisResultsDir}{a \code{character} string, the path to the
directory that contains the analysis results. The path can be the same as
for the \code{permutationResultsDir} parameter. When \code{NULL}, the
observation results are not loaded. Default = \code{NULL}.}

\item{permutationResultsDir}{a \code{character} string, the path to the
directory that contains the permutation results. The path can be the same
as for the \code{analysisResultsDir} parameter. When \code{NULL}, the
permutation results are not loaded. Default = \code{NULL}.}

\item{doingSites}{a \code{logical}, the data related to differentially
methylated sites are loaded when
\code{doingSites} = \code{TRUE}. Default: \code{TRUE}.}

\item{doingTiles}{a \code{logical}, the data related to differentially
methylated tiles are loaded when
\code{doingTiles} = \code{TRUE}. Default: \code{TRUE}.}

\item{maxID}{\code{NA} or a positive \code{integer}, the maximum
identification number of the permutation files to be loaded. When \code{NA},
all files present in the directory are loaded. Default: \code{NA}.}
}
\value{
a \code{list} of class \code{methylInheritanceAllResults}
containing the result of the observation analysis as well as the results
of all the permutations.
}
\description{
Load all RDS files created by the permutation and
observation analysis. The function
returns an object of \code{class} "methylInheritanceAllResults" that holds
all the pertinent information.
}
\examples{

## Get the name of the directory where files are stored
filesDir <- system.file("extdata", "TEST", package="methylInheritance")

## Load information from files
results <- loadAllRDSResults(analysisResultsDir = filesDir,
    permutationResultsDir = filesDir, doingSites = TRUE, doingTiles = TRUE)

## Print the observation results
results

## Access the results for the first permutation only for sites
results$PERMUTATION[[1]]$SITES

}
\seealso{
\code{\link{mergePermutationAndObservation}} for detail
description, in the Value section, of the
\code{methylInheritanceAllResults} object.
}
\author{
Astrid Deschenes, Pascal Belleau
}
