% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batchControl.R, R/methylDBFunctions.R
\docType{methods}
\name{removeComp}
\alias{removeComp}
\alias{removeComp,methylBase-method}
\alias{removeComp,methylBaseDB-method}
\title{Remove principal components from a methylBase object}
\usage{
removeComp(mBase, comp = NULL, chunk.size = 1e+06, save.db = FALSE, ...)

\S4method{removeComp}{methylBase}(mBase, comp = NULL, chunk.size = 1e+06, save.db = FALSE, ...)

\S4method{removeComp}{methylBaseDB}(mBase, comp = NULL, chunk.size = 1e+06, save.db = TRUE, ...)
}
\arguments{
\item{mBase}{\code{\link{methylBase}} or \code{\link{methylBaseDB}} 
object with no NA values, that means
              all bases should be covered in all samples.}

\item{comp}{vector of component numbers to be removed}

\item{chunk.size}{Number of rows to be taken as a chunk for processing 
the \code{methylBaseDB} objects (default: 1e6)}

\item{save.db}{A Logical to decide whether the resulting object should 
be saved as flat file database or not, default: explained in Details sections}

\item{...}{optional Arguments used when save.db is TRUE
          
          \code{suffix}
                A character string to append to the name of the output 
                flat file database, 
                only used if save.db is true, default actions: 
                append \dQuote{_reconstructed} to current filename 
                if database already exists or generate new file with 
                filename \dQuote{methylBase_reconstructed}
                
          \code{dbdir} 
                The directory where flat file database(s) should be 
                stored, defaults
                to getwd(), working directory for newly stored databases
                and to same directory for already existing database
                
         \code{dbtype}
                The type of the flat file database, currently only option 
"tabix"}
}
\value{
new \code{\link{methylBase}} or \code{\link{methylBaseDB}} object
}
\description{
This function can remove a given principal componet from a given 
methylBase object. First, it calculates principal components from
percent methylation matrix and removes the given component(s), reconstructs
the methylation matrix then reconstructs number of methylated and unmethylated Cs per
position based on the reconstructed percent methylation matrix, and finally returns
a new \code{\link{methylBase}} object.
}
\section{Details}{

The parameter \code{chunk.size} is only used when working with 
\code{methylBaseDB} objects, 
as they are read in chunk by chunk to enable processing large-sized 
objects which are stored as flat file database.
Per default the chunk.size is set to 1M rows, which should work for 
most systems. If you encounter memory problems or 
have a high amount of memory available feel free to adjust the 
\code{chunk.size}.

The parameter \code{save.db} is per default TRUE for methylDB objects as
\code{methylBaseDB}, 
while being per default FALSE for \code{methylBase}. If you wish to save 
the result of an 
in-memory-calculation as flat file database or if the size of the 
database allows the calculation in-memory, 
then you might want to change the value of this parameter.
}

\examples{

data(methylKit)

# remove 1st principal component
newObj=removeComp(methylBase.obj,comp=1)

# remove 3rd and 4th  principal components
newObj=removeComp(methylBase.obj,comp=c(3,4))

}
