% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regionalize.R, R/methylDBFunctions.R
\docType{methods}
\name{tileMethylCounts}
\alias{tileMethylCounts}
\alias{tileMethylCounts,methylRaw-method}
\alias{tileMethylCounts,methylRawList-method}
\alias{tileMethylCounts,methylBase-method}
\alias{tileMethylCounts,methylRawDB-method}
\alias{tileMethylCounts,methylRawListDB-method}
\alias{tileMethylCounts,methylBaseDB-method}
\title{Get methylated/unmethylated base counts for tilling windows}
\usage{
tileMethylCounts(object,win.size=1000,step.size=1000,cov.bases=0,mc.cores=1,save.db,...)

\S4method{tileMethylCounts}{methylRaw}(
  object,
  win.size = 1000,
  step.size = 1000,
  cov.bases = 0,
  mc.cores = 1,
  save.db = FALSE,
  ...
)

\S4method{tileMethylCounts}{methylRawList}(
  object,
  win.size = 1000,
  step.size = 1000,
  cov.bases = 0,
  mc.cores = 1,
  save.db = FALSE,
  ...
)

\S4method{tileMethylCounts}{methylBase}(
  object,
  win.size = 1000,
  step.size = 1000,
  cov.bases = 0,
  mc.cores = 1,
  save.db = FALSE,
  ...
)

\S4method{tileMethylCounts}{methylRawDB}(
  object,
  win.size = 1000,
  step.size = 1000,
  cov.bases = 0,
  mc.cores = 1,
  save.db = TRUE,
  ...
)

\S4method{tileMethylCounts}{methylRawListDB}(
  object,
  win.size = 1000,
  step.size = 1000,
  cov.bases = 0,
  mc.cores = 1,
  save.db = TRUE,
  ...
)

\S4method{tileMethylCounts}{methylBaseDB}(
  object,
  win.size = 1000,
  step.size = 1000,
  cov.bases = 0,
  mc.cores = 1,
  save.db = TRUE,
  ...
)
}
\arguments{
\item{object}{\code{\link{methylRaw}}, \code{\link{methylRawDB}},
\code{\link{methylRawList}}, \code{\link{methylRawListDB}},
\code{\link{methylBase}} or \code{\link{methylBaseDB}} object containing
base pair resolution methylation information}

\item{win.size}{an integer for the size of the tiling windows}

\item{step.size}{an integer for the step size of tiling windows}

\item{cov.bases}{minimum number of bases to be covered in a given window}

\item{mc.cores}{number of cores to use when processing \code{methylDB}
objects, default: 1, but always 1 for Windows)}

\item{save.db}{A Logical to decide whether the resulting object should be 
saved as flat file database or not, default: explained in Details sections}

\item{...}{optional Arguments used when save.db is TRUE

\code{suffix}
      A character string to append to the name of the output flat 
      file database, 
      only used if save.db is true, 
      default actions: append \dQuote{_tiled} to current filename 
      if database already exists or generate new file with 
      filename \dQuote{sampleID_tiled} or 
      \dQuote{methylBase_tiled} dependent on input object
      
\code{dbdir} 
      The directory where flat file database(s) should be stored,
      defaults to getwd(), working directory for newly stored
      databases and to same directory for already existing
      database}
}
\value{
\code{methylRaw},\code{methylBase} or \code{methylRawList} object
}
\description{
The function summarizes methylated/unmethylated base counts over tilling 
windows accross genome. This function can be used when differential 
methylation analysis is preferable to tilling windows instead of base pairs.
}
\section{Details}{

The parameter \code{chunk.size} is only used when working with 
\code{methylRawDB}, \code{methylBaseDB} or \code{methylRawListDB} objects, 
as they are read in chunk by chunk to enable processing large-sized objects 
which are stored as flat file database.
Per default the chunk.size is set to 1M rows, which should work for most 
systems. If you encounter memory problems or 
have a high amount of memory available feel free to adjust the \code{chunk.size}.

The parameter \code{save.db} is per default TRUE for methylDB objects as 
\code{methylRawDB}, \code{methylBaseDB} or \code{methylRawListDB}, 
while being per default FALSE for \code{methylRaw}, \code{methylBase} or
 \code{methylRawList}. If you wish to save the result of an 
in-memory-calculation as flat file database or if the size of the database 
allows the calculation in-memory, 
then you might want to change the value of this parameter.
}

\examples{
data(methylKit)

tiled.methylRaw=tileMethylCounts(object=methylRawList.obj,win.size=1000,
                                 step.size=1000,cov.bases=0)


}
