% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diff_binomial.R
\name{diff_binomial}
\alias{diff_binomial}
\title{Differential methylation analysis using binomial model}
\usage{
diff_binomial(bs, group_column, comparison_groups)
}
\arguments{
\item{bs}{A \code{BSseq-class} object to calculate differential methylation statistics. See \code{methylSigReadData} for how to read in methylation data.}

\item{group_column}{a \code{character} string indicating the column of \code{pData(bs)} to use for determining group membership.}

\item{comparison_groups}{a named \code{character} vector indicating the \code{case} and \code{control} factors of \code{group_column} for the comparison.}
}
\value{
A \code{GRanges} object containing the following \code{mcols}:
\describe{
  \item{meth_case:}{ Methylation estimate for case. }
  \item{meth_control:}{ Methylation estimate for control. }
  \item{meth_diff:}{ The difference \code{meth_case - meth_control}. }
  \item{direction:}{ The group for which the lcous is hyper-methylated. Note, this is not subject to significance thresholds. }
  \item{pvalue:}{ The p-value from the t-test (\code{t_approx = TRUE}) or the Chi-Square test (\code{t_approx = FALSE}). }
  \item{fdr:}{ The Benjamini-Hochberg adjusted p-values using \code{p.adjust(method = 'BH')}. }
  \item{log_lik_ratio:}{ The log likelihood ratio. }
}
}
\description{
This function calculates differential methylation statistics using a binomial-based approach. See `Warning' message below.
}
\details{
This function uses a binomial-based model to calculate differential methylation statistics. It is nearly identical to the \code{methylKit::calculateDiffMeth} function in the \code{methylKit} R package except that only the likelihood ratio test and \code{p.adjust(..., method='BH')} are used to calculate significance levels. It is significantly faster than \code{methylKit::calculateDiffMeth} function.
}
\section{Warning}{
 This function does not take into account the variability among samples in each group being compared.
}

\examples{
data(BS.cancer.ex, package = 'bsseqData')

bs = filter_loci_by_group_coverage(
    bs = BS.cancer.ex,
    group_column = 'Type',
    c('cancer' = 2, 'normal' = 2))

small_test = bs[1:50]

diff_gr = diff_binomial(
    bs = small_test,
    group_column = 'Type',
    comparison_groups = c('case' = 'cancer', 'control' = 'normal'))

}
