% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get1DCutoff.R
\name{get1DCutoff}
\alias{get1DCutoff}
\title{get1DCutoff}
\usage{
get1DCutoff(
  sce,
  model = NULL,
  posterior_cutoff = 0.75,
  subsets_mito_percent = "subsets_mito_percent"
)
}
\arguments{
\item{sce}{(SingleCellExperiment) Input data object.}

\item{model}{(flexmix) Output of mixtureModel function, which should be
explicitly called first to ensure stability of model parameters.
Default = NULL.}

\item{posterior_cutoff}{(numeric) The posterior probability of a cell being
part of the compromised distribution, a number between 0 and 1. Any cells
below the appointed cutoff will be marked to keep.
Default = 0.75}

\item{subsets_mito_percent}{(character) Column name in sce giving the
percent of reads mapping to mitochondrial genes. This name is inherited
from scater's addPerCellQC() function, provided the subset "mito" with
names of all mitochondrial genes is passed in. See examples for details.}
}
\value{
Returns a single numeric value, the percent mitochondrial cutoff
at which to filter cells.
}
\description{
When the model is generated based only on mitochondrial percentage, e.g.
run_model(sce, model_type = "one_dimensional"), there will be a discrete 
cutoff point at which to remove cells with at least that mitochondrial
percentage. This function identifies this cutoff based on a given posterior
probability threshold. This number can then be passed as a cutoff to other
modalities.
}
\examples{
library(scRNAseq)
library(scater)
sce <- ZeiselBrainData()
mt_genes <- grepl("^mt-",  rownames(sce))
feature_ctrls <- list(mito = rownames(sce)[mt_genes])
sce <- addPerCellQC(sce, subsets = feature_ctrls)
model <- mixtureModel(sce, model_type = "one_dimensional")
get1DCutoff(sce, model)
}
