% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miRSM.R
\name{module_miRdistribute}
\alias{module_miRdistribute}
\title{module_miRdistribute}
\usage{
module_miRdistribute(share_miRs)
}
\arguments{
\item{share_miRs}{List object: a list of common miRNAs of each miRNA sponge module 
generated by share_miRs function.}
}
\value{
Matrix object: miRNA distribution in each miRNA sponge module.
}
\description{
miRNA distribution analysis of sharing miRNAs by the identified miRNA sponge modules
}
\examples{
data(BRCASampleData)
modulegenes_WGCNA <- module_WGCNA(ceRExp, mRExp)
# Identify miRNA sponge modules using sensitivity RV coefficient (SRVC)
miRSM_WGCNA_SRVC <- miRSM(miRExp, ceRExp, mRExp, miRTarget,
                        modulegenes_WGCNA, method = "SRVC",
                        SMC.cutoff = 0.01, RV_method = "RV")
miRSM_WGCNA_SRVC_genes <- miRSM_WGCNA_SRVC[[2]]
miRSM_WGCNA_share_miRs <-  share_miRs(miRExp, miRTarget, miRSM_WGCNA_SRVC_genes)
miRSM_WGCNA_miRdistribute <- module_miRdistribute(miRSM_WGCNA_share_miRs)

}
\author{
Junpeng Zhang (\url{https://www.researchgate.net/profile/Junpeng-Zhang-2})
}
