% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/getShortTermChange.R
\name{addShortTermChange}
\alias{addShortTermChange}
\alias{getShortTermChange}
\alias{addShortTermChange,SummarizedExperiment-method}
\alias{getShortTermChange,SummarizedExperiment-method}
\title{Short term changes in abundance}
\usage{
addShortTermChange(x, ...)

getShortTermChange(x, ...)

\S4method{addShortTermChange}{SummarizedExperiment}(x, name = "short_term_change", ...)

\S4method{getShortTermChange}{SummarizedExperiment}(x, time.col, assay.type = "counts", group = NULL, ...)
}
\arguments{
\item{x}{A
\code{\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}}
object.}

\item{...}{additional arguments.
\itemize{
\item \code{time.interval}: \code{Integer scalar}. Indicates the increment
between time steps. By default, the function compares each sample to the
previous one. If you need to take every second, every third, or so, time
step, then increase this accordingly. (Default: \code{1L})
}}

\item{name}{\code{Character scalar}. Specifies a name for storing
short term results. (Default: \code{"short_term_change"})}

\item{time.col}{\code{Character scalar}. Specifies a name of the column from
\code{colData} that identifies the sampling time points for the samples.}

\item{assay.type}{\code{Character scalar}. Specifies which assay values are
used in the dissimilarity estimation. (Default: \code{"counts"})}

\item{group}{\code{Character scalar}. Specifies a name of the column from
\code{colData} that identifies the grouping of the samples.
(Default: \code{NULL})}
}
\value{
\code{getShortTermChange} returns \code{DataFrame} object containing
the short term change in abundance over time for a microbe.
\code{addShortTermChange}, on the other hand, returns a
\code{\link[SummarizedExperiment:SummarizedExperiment]{SummarizedExperiment}}
object with these results in its \code{metadata}.
}
\description{
Calculates short term changes in abundance of taxa using temporal
abundance data.
}
\details{
These functions can be utilized to calculate growth metrics for short term
change. In specific, the functions calculate the metrics with the following
equations:

\deqn{time\_diff = time_{t} - time_{t-1}}

\deqn{abundance\_diff = abundance_{t} - abundance_{t-1}}

\deqn{growth\_rate = abundance\_diff - abundance_{t-1}}

\deqn{rate\_of\_change = abundance\_diff - time\_diff}
}
\examples{
library(miaTime)

# Load time series data
data(minimalgut)
tse <- minimalgut

# Get relative abundances
tse <- transformAssay(tse, method = "relabundance")
# Calculate short term changes
df <- getShortTermChange(
  tse, assay.type = "relabundance", time.col = "Time.hr",
  group = "StudyIdentifier")

# Calculate the logarithm of the ratio described in Ji, B.W., et al. (2020)
tse <- transformAssay(
    tse, assay.type = "relabundance", method = "log10", pseudocount = TRUE)
df <- getShortTermChange(
  tse, assay.type = "log10", time.col = "Time.hr", group = "StudyIdentifier")

# Select certain bacteria that have highest growth rate
select <- df[["growth_rate"]] |> abs() |> order(decreasing = FALSE)
select <- df[select, "FeatureID"] |> unique() |> head(3)
df <- df[ which(df[["FeatureID"]] \%in\% select), ]

# Plot results
library(ggplot2)
p <- ggplot(df, aes(x = Time.hr, y = growth_rate, colour = FeatureID)) +
    geom_smooth(level = 0.5) +
    facet_grid(. ~ StudyIdentifier, scales = "free") +
    scale_y_log10()
p

}
\references{
Ji, B.W., et al. (2020) Macroecological dynamics of gut microbiota.
Nat Microbiol 5, 768–775 . doi: https://doi.org/10.1038/s41564-020-0685-1
}
\seealso{
\code{\link[miaTime:getStepwiseDivergence]{getStepwiseDivergence()}}
}
