% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_levels.R
\name{map_levels}
\alias{map_levels}
\title{Map Taxonomic Levels}
\usage{
map_levels(taxa = NULL, from, to, data)
}
\arguments{
\item{taxa}{taxa to convert; if NULL then considering all taxa in the
tax.table}

\item{from}{convert from taxonomic level}

\item{to}{convert to taxonomic level}

\item{data}{Either a \code{\link{phyloseq}} object or its
\code{\link{taxonomyTable-class}} , see the \pkg{phyloseq} package.}
}
\value{
mappings
}
\description{
Map taxa between hierarchy levels.
}
\examples{
data(dietswap)
m <- map_levels('Akkermansia', from='Genus', to='Phylum',
tax_table(dietswap))
m <- map_levels('Verrucomicrobia', from='Phylum', to='Genus',
tax_table(dietswap))
}
\references{
See citation('microbiome')
}
\author{
Contact: Leo Lahti \email{microbiome-admin@googlegroups.com}
}
\keyword{utilities}
