% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transformationFunctions.R
\name{hlaCallsToCounts}
\alias{hlaCallsToCounts}
\title{Transform HLA calls to counts table}
\usage{
hlaCallsToCounts(hla_calls, check_hla_format = TRUE)
}
\arguments{
\item{hla_calls}{HLA calls data frame, as returned by
\code{\link{readHlaCalls}} function.}

\item{check_hla_format}{Logical indicating if \code{hla_calls} format should
be checked. This is useful if one wants to use \code{hlaCallsToCounts} with
input not adhering to HLA nomenclature standards. See examples.}
}
\value{
HLA allele counts data frame. First column holds samples ID's, further 
  columns, corresponding to specific alleles, give information on the number 
  of their occurrences in each sample.
}
\description{
\code{hlaCallsToCounts} converts HLA calls data frame into a counts table.
}
