% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{iterativeModel}
\alias{iterativeModel}
\title{Iteratively evaluate model for different variables}
\usage{
iterativeModel(object, placeholder, variables, exponentiate = FALSE)
}
\arguments{
\item{object}{An existing fit from a model function such as lm, glm and many
others.}

\item{placeholder}{String specifying term to substitute with value from
\code{x}. Ignored if set to \code{NULL}.}

\item{variables}{Character vector specifying variables to use in association
tests.}

\item{exponentiate}{Logical flag indicating whether or not to exponentiate
the coefficient estimates. Internally this is passed to
\code{\link[broom]{tidy}}. This is typical for logistic and multinomial
regressions, but a bad idea if there is no log or logit link. Defaults to
FALSE.}
}
\value{
Tibble containing per variable summarised model statistics. The exact
  output format is model dependent and controlled by model's dedicated 
  \code{tidy} function.
}
\description{
Information about variable statistic from each model is extracted using 
\code{tidy} function.
}
