% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildFromAdjacency.R
\name{buildFromAdjacency}
\alias{buildFromAdjacency}
\title{Build a graph from an input adjacency matrix}
\arguments{
\item{x}{An n X n \code{matrix} of single-cells, where values represent edges between cells; 0 values
are taken to mean no edge between cells. If the matrix is not binary, then it is assumed the values
are distances; 0 retain the same meaning. This behaviour can be toggled using \code{is.binary=TRUE}.}

\item{k}{(optional) Scalar value that represents the number of nearest neighbours in the original graph. This
can also be inferred directly from the adjacency matrix \code{x}.}

\item{is.binary}{Logical scalar indicating if the input matrix is binary or not.}
}
\value{
A \code{\linkS4class{Milo}} with the graph slot populated.
}
\description{
Construct a kNN-graph from an input adjacency matrix - either binary or distances between NNs.
}
\details{
This function will take a matrix as input and construct the kNN graph that it describes. If
the matrix is not symmetric then the graph is assumed to be directed, whereas if the matrix
is not binary, i.e. all 0's and 1's then the input values are taken to be distances between
graph vertices; 0 values are assumed to represent a lack of edge between vertices.
}
\examples{
r <- 1000
c <- 1000
k <- 35
m <- floor(matrix(runif(r*c), r, c))
for(i in seq_along(1:r)){
    m[i, sample(1:c, size=k)] <- 1
}

milo <- buildFromAdjacency(m)

}
\author{
Mike Morgan
}
