% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildGraph.R
\name{buildGraph}
\alias{buildGraph}
\title{Build a k-nearest neighbour graph}
\usage{
buildGraph(
  x,
  k = 10,
  d = 50,
  transposed = FALSE,
  get.distance = FALSE,
  reduced.dim = "PCA",
  BNPARAM = KmknnParam(),
  BSPARAM = bsparam(),
  BPPARAM = SerialParam()
)
}
\arguments{
\item{x}{A matrix, \code{\linkS4class{SingleCellExperiment}} or Milo object
containing feature X cell gene expression data.}

\item{k}{An integer scalar that specifies the number of nearest-neighbours
to consider for the graph building.}

\item{d}{The number of dimensions to use if the input is a matrix of cells
X reduced dimensions. If this is provided, transposed should also be
set=TRUE.}

\item{transposed}{Logical if the input x is transposed with rows as cells.}

\item{get.distance}{A logical scalar whether to compute distances during graph
construction.}

\item{reduced.dim}{A character scalar that refers to a specific entry in
the \code{reduceDim} slot of the \code{\linkS4class{Milo}} object.}

\item{BNPARAM}{refer to \code{\link[scran]{buildKNNGraph}} for details.}

\item{BSPARAM}{refer to \code{\link[scran]{buildKNNGraph}} for details.}

\item{BPPARAM}{refer to \code{\link[scran]{buildKNNGraph}} for details.}
}
\value{
A \code{\linkS4class{Milo}} object with the graph and distance slots populated.
}
\description{
This function is borrowed from the old buildKNNGraph function in scran.
Instead of returning an igraph object it populates the graph and distance
slots in a Milo object. If the input is a SingleCellExperiment object or
a matrix then it will return a de novo Milo object with the same slots
filled.
}
\details{
This function computes a k-nearest neighbour graph. Each graph vertex is a
single-cell connected by the edges between its neighbours. Whilst a
kNN-graph is strictly directed, we remove directionality by forcing all
edge weights to 1; this behaviour can be overriden by providing
\code{directed=TRUE}.

If you wish to use an
alternative graph structure, such as a shared-NN graph I recommend you
construct this separately and add to the relevant slot in the
\code{\link{Milo}} object.
}
\examples{
library(SingleCellExperiment)
ux <- matrix(rpois(12000, 5), ncol=200)
vx <- log2(ux + 1)
pca <- prcomp(t(vx))

sce <- SingleCellExperiment(assays=list(counts=ux, logcounts=vx),
                            reducedDims=SimpleList(PCA=pca$x))

milo <- Milo(sce)
milo <- buildGraph(milo, d=30, transposed=TRUE)

milo
}
\author{
Mike Morgan, with KNN code written by Aaron Lun & Jonathan Griffiths.
}
