% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/countCells.R
\name{countCells}
\alias{countCells}
\title{Count cells in neighbourhoods}
\usage{
countCells(x, samples, meta.data = NULL)
}
\arguments{
\item{x}{A \code{\linkS4class{Milo}} object with non-empty \code{graph} and
\code{nhoods} slots.}

\item{samples}{Either a string specifying which column of \code{data}
should be used to identify the experimental samples for counting, or a
named vector of sample ids mapping each single cell to it's respective sample.}

\item{meta.data}{A cell X variable \code{data.frame}  containing study meta-data
including experimental sample IDs. Assumed to be in the same order as the
cells in the input \code{\linkS4class{Milo}} object.}
}
\value{
A \code{\linkS4class{Milo}} object containing a counts matrix in the
\code{nhoodCounts} slot.
}
\description{
This function quantifies the number of cells in each neighbourhood according
to an input experimental design. This forms the basis for the differential
neighbourhood abundance testing.
}
\details{
This function generates a counts matrix of \code{nhoods} X samples,
and populates the \code{nhoodCounts} slot of the input
\code{\linkS4class{Milo}} object. This matrix is used down-stream for
differential abundance testing.
}
\examples{

library(igraph)
m <- matrix(rnorm(100000), ncol=100)
milo <- buildGraph(t(m), k=20, d=10)
milo <- makeNhoods(milo, k=20, d=10, prop=0.3)

cond <- rep("A", nrow(m))
cond.a <- sample(seq_len(nrow(m)), size=floor(nrow(m)*0.25))
cond.b <- setdiff(seq_len(nrow(m)), cond.a)
cond[cond.b] <- "B"
meta.df <- data.frame(Condition=cond, Replicate=c(rep("R1", 330), rep("R2", 330), rep("R3", 340)))
meta.df$SampID <- paste(meta.df$Condition, meta.df$Replicate, sep="_")
milo <- countCells(milo, meta.data=meta.df, samples="SampID")
milo

}
\author{
Mike Morgan, Emma Dann
}
