% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/view-manipulators.R
\name{select_markers}
\alias{select_markers}
\title{Select a subset of markers in a view}
\usage{
select_markers(current.views, view = "intraview", ...)
}
\arguments{
\item{current.views}{the current view composition.}

\item{view}{the name of the view to select markers for.}

\item{...}{one or more \link[dplyr:dplyr_tidy_select]{select} expressions
\code{\link[dplyr:select]{dplyr::select}()} for the specified \code{view}.}
}
\value{
A mistyR view composition with selected markers in \code{view}.
}
\description{
Select a subset of markers in a view
}
\examples{
# Create a view composition with an intraview and select

library(dplyr)

# get the expression data
data("synthetic")
expr <- synthetic[[1]] \%>\% select(-c(row, col, type))

# compose
misty.views <- create_initial_view(expr)

# select markers from the intraview not starting with lig and preview
misty.views \%>\%
  select_markers("intraview", !starts_with("lig")) \%>\%
  str()
}
\seealso{
<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}>.

Other view manipulation functions: 
\code{\link{filter_views}()},
\code{\link{rename_view}()}
}
\concept{view manipulation functions}
