% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mitch.R
\name{mitch_import}
\alias{mitch_import}
\title{mitch_import}
\usage{
mitch_import(x, DEtype, geneIDcol = NULL, geneTable = NULL, joinType = NULL)
}
\arguments{
\item{x}{a list of differential expression tables.}

\item{DEtype}{the program that generated the differential expression table
Valid options are 'edgeR', 'DESeq2', 'limma', 'ABSSeq', 'Sleuth', 'Seurat',
'topConfects', 'muscat', 'Swish', 'scDE', 'MAST', 'DEsingle', 'ballgown',
'NOIseq', 'TCC', 'DEDS', 'cuffdiff', 'fishpond', 'missMethyl', 'DMRcate',
'DEP', 'msmsTests', 'plgem', 'SDAMS', 'DEqMS', 'DiffBind' and 'prescored'. 
Where 'prescored' is a dataframe containing the test statistic and gene ID 
(either in rowname or separate column) and nothing else. 'preranked' is an 
alias for 'prescored'.}

\item{geneIDcol}{the column containing gene names. If gene names are 
specified as row names, then geneIDcol=NULL.}

\item{geneTable}{a 2 column table mapping gene identifiers in the profile to
gene identifiers in the gene sets.}

\item{joinType}{the type of join to perform, either 'inner' or 'full'.
By default, joins are 'inner' except for Seurat and muscat where full is 
used.}
}
\value{
a multi-column table compatible with mitch_calc analysis.
}
\description{
This function imports differential omics data from common differential tools
like edgeR, limma and DESeq2. It calculates a summarised differential
expression metric by multiplying the sign of the log fold change by the 
-log10 of the p-value. If this behaviour is not desired, mitch_import can be
bypassed in favour of another scoring metric.
}
\examples{
# first step is to create a list of differential profiles
data(rna,k9a,k36a)
x<-list('rna'=rna,'k9a'=k9a,'k36a'=k36a)
# import as edgeR table 
imported<-mitch_import(x,DEtype='edger')
}
\keyword{import}
\keyword{mitch}
