% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mitch.R
\name{networkplot}
\alias{networkplot}
\title{networkplot}
\usage{
networkplot(eres, FDR = 0.05, n_sets = 20)
}
\arguments{
\item{eres}{a mitch results object.}

\item{FDR}{the significance threshold for inclusion. By default, it is 0.05}

\item{n_sets}{the number of sets to include. This type of graph can get messy,
so the default is 20, but it can be customised to your needs.}
}
\value{
generates network diagrams.
}
\description{
This function generates gene set network diagrams to complement the enrichment analysis.
It produces separate charts for up and down-regulated sets.
This only includes genes ranked in the top and bottom tertiles.
Genes in the set which do not meet this criterion are discarded.
The intensity of the colour is proportional to the s.dist value (enrichment score).
Circle size is proportional to the number of genes in the set.
Line thickness is proportional to the Jaccard similarity value.
This function works best after prioritisation with "effect" when running
mitch_calc().
Note that the circle size and the line width shown in the legend is approximate,
although the values shown are exactly the smallest and largest respectively.
Note that this chart works best when the width is double the height, otherwise
many of the long gene set names could be cut off.
There is an element of stochasticity with regard to the network projection, so
it could be a good idea to repeat it a few times until you get a nice layout.
}
\examples{
data(resExample)
networkplot(resExample)
}
\keyword{mitch}
\keyword{network}
\keyword{visualisation}
