% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{removeWindow}
\alias{removeWindow}
\title{Remove mutations that occuring at the same site}
\usage{
removeWindow(x, window = 1)
}
\arguments{
\item{x}{A list of strings that comprise sites that will be filtered}

\item{window}{Integer of how close mutations must be to one another
(in bp) to be removed}
}
\value{
Returns the same list of mutations excluding those, if any,
that fall within the same window =
}
\description{
Mutations co-occuring at the same genomic position may often be the
result of sequencing artifacts or technical biases. In cases where
the user which to drop these from a result this function may be
used. ONLY WORKS FOR MITOCHONDRIAL MUTATIONS.
}
\examples{
P1.muts <- rep(TRUE,3)
names(P1.muts) <- c("X2537GA","X3351TC","X3350TC")
names(P1.muts) <- gsub("^X","",
gsub("(\\\\d+)([AGCT])([AGCT])","\\\\1 \\\\2>\\\\3",names(P1.muts)))
P1.muts <- P1.muts[removeWindow(names(P1.muts))]
}
