% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nipals.R
\name{nipals}
\alias{nipals}
\title{Non-linear Iterative Partial Least Squares (NIPALS) algorithm}
\usage{
nipals(X, ncomp = 2, max.iter = 500, tol = 1e-06)
}
\arguments{
\item{X}{a numeric matrix (or data frame) which provides the data for the
principal components analysis. It can contain missing values in which case
\code{center = TRUE} is used as required by the
\code{\link{nipals}} function.}

\item{ncomp}{Integer, if data is complete \code{ncomp} decides the number of
components and associated eigenvalues to display from the \code{pcasvd}
algorithm and if the data has missing values, \code{ncomp} gives the number
of components to keep to perform the reconstitution of the data using the
NIPALS algorithm. If \code{NULL}, function sets \code{ncomp = min(nrow(X),
ncol(X))}}

\item{max.iter}{Integer, the maximum number of iterations in the NIPALS
algorithm.}

\item{tol}{Positive real, the tolerance used in the NIPALS algorithm.}
}
\value{
An object of class 'mixo_nipals' containing slots: 
\item{eig}{Vector containing the pseudo-singular values of \code{X}, of length
\code{ncomp}.}
\item{t}{Matrix whose columns contain the left singular vectors of \code{X}.
Note that for a complete data matrix X, the return values \code{eig},
\code{t} and \code{p} such that \code{X = t * diag(eig) * t(p)}.}
}
\description{
This function performs NIPALS algorithm, i.e. the singular-value
decomposition (SVD) of a data table that can contain missing values.
}
\details{
The NIPALS algorithm (Non-linear Iterative Partial Least Squares) has been
developed by H. Wold at first for PCA and later-on for PLS. It is the most
commonly used method for calculating the principal components of a data set.
It gives more numerically accurate results when compared with the SVD of the
covariance matrix, but is slower to calculate.

This algorithm allows to realize SVD with missing data, without having to
delete the rows with missing data or to estimate the missing data.
}
\references{
Tenenhaus, M. (1998). \emph{La regression PLS: theorie et
pratique}. Paris: Editions Technic.

Wold H. (1966). Estimation of principal components and related models by
iterative least squares. In: Krishnaiah, P. R. (editors), \emph{Multivariate
Analysis}. Academic Press, N.Y., 391-420.

Wold H. (1975). Path models with latent variables: The NIPALS approach. In:
Blalock H. M. et al. (editors). \emph{Quantitative Sociology: International
perspectives on mathematical and statistical model building}. Academic
Press, N.Y., 307-357.
}
\seealso{
\code{\link{impute.nipals}}, \code{\link{svd}},
  \code{\link{princomp}}, \code{\link{prcomp}}, \code{\link{eigen}} and
  http://www.mixOmics.org for more details.
}
\author{
Sébastien Déjean, Ignacio González, Kim-Anh Le Cao, Al J Abadi
}
\keyword{algebra}
\keyword{multivariate}
