% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S3methods-plot.perf.R
\name{plot.perf}
\alias{plot.perf}
\alias{plot.perf.plsda.mthd}
\alias{plot.perf.splsda.mthd}
\alias{plot.perf.mint.plsda.mthd}
\alias{plot.perf.mint.splsda.mthd}
\alias{plot.perf.sgccda.mthd}
\title{Plot for model performance for PSLDA analyses}
\usage{
\method{plot}{perf.plsda.mthd}(
  x,
  dist = c("all", "max.dist", "centroids.dist", "mahalanobis.dist"),
  measure = c("all", "overall", "BER"),
  col,
  xlab = NULL,
  ylab = NULL,
  overlay = c("all", "measure", "dist"),
  legend.position = c("vertical", "horizontal"),
  sd = TRUE,
  ...
)

\method{plot}{perf.splsda.mthd}(
  x,
  dist = c("all", "max.dist", "centroids.dist", "mahalanobis.dist"),
  measure = c("all", "overall", "BER"),
  col,
  xlab = NULL,
  ylab = NULL,
  overlay = c("all", "measure", "dist"),
  legend.position = c("vertical", "horizontal"),
  sd = TRUE,
  ...
)

\method{plot}{perf.mint.plsda.mthd}(
  x,
  dist = c("all", "max.dist", "centroids.dist", "mahalanobis.dist"),
  measure = c("all", "overall", "BER"),
  col,
  xlab = NULL,
  ylab = NULL,
  study = "global",
  overlay = c("all", "measure", "dist"),
  legend.position = c("vertical", "horizontal"),
  ...
)

\method{plot}{perf.mint.splsda.mthd}(
  x,
  dist = c("all", "max.dist", "centroids.dist", "mahalanobis.dist"),
  measure = c("all", "overall", "BER"),
  col,
  xlab = NULL,
  ylab = NULL,
  study = "global",
  overlay = c("all", "measure", "dist"),
  legend.position = c("vertical", "horizontal"),
  ...
)

\method{plot}{perf.sgccda.mthd}(
  x,
  dist = c("all", "max.dist", "centroids.dist", "mahalanobis.dist"),
  measure = c("all", "overall", "BER"),
  col,
  weighted = TRUE,
  xlab = NULL,
  ylab = NULL,
  overlay = c("all", "measure", "dist"),
  legend.position = c("vertical", "horizontal"),
  sd = TRUE,
  ...
)
}
\arguments{
\item{x}{an \code{perf.plsda} object.}

\item{dist}{prediction method applied in \code{perf} for \code{plsda} or
\code{splsda}. See \code{\link{perf}}.}

\item{measure}{Two misclassification measure are available: overall
misclassification error \code{overall} or the Balanced Error Rate \code{BER}}

\item{col}{character (or symbol) colour to be used, possibly vector. One
color per distance \code{dist}.}

\item{xlab, ylab}{titles for \eqn{x} and \eqn{y} axes.  Typically character
strings, but can be expressions (e.g., \code{expression(R^2)}).}

\item{overlay}{parameter to overlay graphs; if 'all', only one graph is
shown with all outputs; if 'measure', a graph is shown per distance; if
'dist', a graph is shown per measure.}

\item{legend.position}{position of the legend, one of "vertical" (only one
column) or "horizontal" (two columns).}

\item{sd}{If 'nrepeat' was used in the call to 'perf', error bar shows the
standard deviation if sd=TRUE. For mint objects sd is set to FALSE as the
number of repeats is 1.}

\item{...}{Not used.}

\item{study}{Indicates which study-specific outputs to plot. A character
vector containing some levels of \code{object$study}, "all.partial" to plot
all studies or "global" is expected. Default to "global".}

\item{weighted}{plot either the performance of the Majority vote or the
Weighted vote.}
}
\value{
none
}
\description{
Function to plot classification performance for supervised
methods, as a function of the number of components.
}
\details{
More details about the prediction distances in \code{?predict} and the
supplemental material of the mixOmics article (Rohart et al. 2017).
See ?perf for examples.
}
\references{
Rohart F, Gautier B, Singh A, Lê Cao K-A. mixOmics: an R package for 'omics
feature selection and multiple data integration. PLoS Comput Biol 13(11):
e1005752
}
\seealso{
\code{\link{pls}}, \code{\link{spls}}, \code{\link{plsda}},
\code{\link{splsda}}, \code{\link{perf}}.
}
\author{
Ignacio González, Florian Rohart, Francois Bartolo, Kim-Anh Lê Cao, Al J Abadi
}
\keyword{hplot}
\keyword{multivariate}
\keyword{regression}
