% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tune.splslevel.R
\name{tune.splslevel}
\alias{tune.splslevel}
\title{Parallelized Tuning function for multilevel sPLS method using BiocParallel}
\usage{
tune.splslevel(
  X,
  Y,
  multilevel,
  ncomp = NULL,
  mode = "regression",
  test.keepX = rep(ncol(X), ncomp),
  test.keepY = rep(ncol(Y), ncomp),
  already.tested.X = NULL,
  already.tested.Y = NULL,
  BPPARAM = BiocParallel::SerialParam(),
  seed = NULL
)
}
\arguments{
\item{X}{numeric matrix of predictors. \code{NA}s are allowed.}

\item{Y}{\code{if(method = 'spls')} numeric vector or matrix of continuous
responses (for multi-response models) \code{NA}s are allowed.}

\item{multilevel}{Design matrix for multilevel analysis (for repeated
measurements) that indicates the repeated measures on each individual, i.e.
the individuals ID. See Details.}

\item{ncomp}{the number of components to include in the model.}

\item{mode}{character string. What type of algorithm to use, (partially)
matching one of \code{"regression"}, \code{"canonical"}, \code{"invariant"}
or \code{"classic"}.}

\item{test.keepX}{numeric vector for the different number of variables to
test from the \eqn{X} data set}

\item{test.keepY}{numeric vector for the different number of variables to
test from the \eqn{Y} data set}

\item{already.tested.X}{Optional, if \code{ncomp > 1} A numeric vector
indicating the number of variables to select from the \eqn{X} data set on
the firsts components.}

\item{already.tested.Y}{Optional, if \code{ncomp > 1} A numeric vector
indicating the number of variables to select from the \eqn{Y} data set on
the firsts components.}

\item{BPPARAM}{BiocParallelParam object to manage parallelization}

\item{seed}{set a number here if you want the function to give reproducible outputs. 
Not recommended during exploratory analysis. Note if RNGseed is set in 'BPPARAM', this will be overwritten by 'seed'.}
}
\value{
\item{cor.value}{correlation between latent variables}
}
\description{
For a multilevel spls analysis, the tuning criterion is based on the
maximisation of the correlation between the components from both data sets
}
