% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mnems.r
\name{plot.mnem_mcmc}
\alias{plot.mnem_mcmc}
\title{Plot mnem_mcmc result.}
\usage{
\method{plot}{mnem_mcmc}(x, starts = NULL, burnin = 0, ...)
}
\arguments{
\item{x}{mnem_mcmc object}

\item{starts}{restarts of mcmc as used in mnem function}

\item{burnin}{number of iteration to start from}

\item{...}{parameters for function ggplot2}
}
\value{
visualization of mcmc result with Rgraphviz
}
\description{
Plot mnem_mcmc result.
}
\examples{
sim <- simData(Sgenes = 3, Egenes = 2, Nems = 2, mw = c(0.4,0.6))
data <- (sim$data - 0.5)/0.5
data <- data + rnorm(length(data), 0, 1)
result <- mnem(data, k = 2, starts = 1)
plot(result)
}
\author{
Viktoria Brunner
}
