% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{bicluster_heatmap,bicluster,matrix-method}
\alias{bicluster_heatmap,bicluster,matrix-method}
\title{Plot a heatmap of a bicluster}
\usage{
\S4method{bicluster_heatmap}{bicluster,matrix}(bic, m, ...)
}
\arguments{
\item{bic}{A bicluster object.}

\item{m}{The matrix, that was used for the
biclustering. (Works only if matrix has row-/colnames.)}

\item{...}{Arguments forwarded to \code{stats::\link[stats]{heatmap}}.}
}
\value{
A plot object
}
\description{
Uses the \code{stats::\link[stats]{heatmap}} function.
}
\examples{
m <- matrix(c(1,2,3,4), nrow=2)
rownames(m) <- c("r1", "r2")
rownames(m) <- c("c1", "c2")
bicluster_heatmap(bicluster(row=c(1,2), column=c(1,2)), m)

}
