% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_biclusters.R
\name{get_biclusters}
\alias{get_biclusters}
\title{Extract biclusters from different algorithms/packages}
\usage{
get_biclusters(bics, mat, method, transposed = FALSE, filterfun = NULL, ...)
}
\arguments{
\item{bics}{A resulting object from a biclustering
algorithm (extracted biclusters for fabia) or filename for stored
biclustering results.}

\item{mat}{Original matrix, that was used for biclustering.}

\item{method}{Used biclustering package. One of "biclust"
(can be further specified as "biclust-bimax",
"biclust-cc", "biclust-plaid", "biclust-quest",
"biclust-qubic",
"biclust-spectral", "biclust-xmotifs", "biclust-unibic"),
"BicARE", "isa", "fabia", "biforce", "biclustpy", "qubic2"
or "akmbiclust".}

\item{transposed}{Indicate, whether a transposed version of the matrix is
used for biclustering. The \code{matrix} should not be transposed,
when this argument is set to \code{True}.}

\item{filterfun}{A function to filter biclusters.
Only if the function returns \code{True}, the bicluster is added to
the returned list. The function has to accept a bicluster
(given as submatrix of \code{mat}) \code{filterfun(bicluster_matrix, ...)}.}

\item{...}{Other parameters forwarded to the \code{filterfun}.}
}
\value{
A list of \code{\link{bicluster}} objects, which are
valid (See \code{\link{validate_bicluster}}).
}
\description{
Converts biclusters output of different algorithms/packages in to lists
of \link{bicluster} objects. Many algoritms can be directly executed using
the \code{run_...} methods from this package.
This directly returns the converted results. Not all algorithms are shipped
with this package, like Bi-Force, which is running in Java as a standalone
tool or BicARE,
which required an full import using \code{library(BicARE)} in order to run.
But their results can be converted using this function.
}
\examples{
m <- matrix(seq(1:16), nrow=4)
# m <- matrix(rnorm(10000), nrow=100)
# res <- isa2::isa(m)
# get_biclusters(res, m, "isa")

}
