% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bicluster_net_methods.R
\name{get_louvain_communities}
\alias{get_louvain_communities}
\title{Get louvain communities from a bicluster network}
\usage{
get_louvain_communities(bic_net, min_size = 2, bics = NULL)
}
\arguments{
\item{bic_net}{A \code{\link{bicluster_net}}
or \code{\link{cooccurrence_net}}object.}

\item{min_size}{Minimum size of a louvain community to be
returned (minimum value is 2).}

\item{bics}{Optional. Is only use for the class \code{\link{bicluster_net}}.
The respective list of biclusters to identify,
from which algorithms a community originates.}
}
\value{
A list of \code{\link{bicluster_net}}
or \code{\link{cooccurrence_net}} objects.
}
\description{
Extracts the louvain communities from a \code{\link{bicluster_net}}
or \code{\link{cooccurrence_net}} object using the louvain modularity
optimization from the \code{igraph}
package (\code{\link[igraph]{cluster_louvain}}).
}
\examples{
m <- matrix(seq(1:16), nrow=4)
# m <- matrix(rnorm(10000), nrow=100)
# bics <- c(run_fabia(m), run_isa(m), run_plaid(m))
# bn <- bicluster_network(bics, m)
# get_louvain_communities(bn)

}
