% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{occurance_table}
\alias{occurance_table}
\title{Occurance table of data points in a list of biclusters}
\usage{
occurance_table(bics, mat, threshold = 0)
}
\arguments{
\item{bics}{A list of \code{\link{bicluster}} objects.}

\item{mat}{The data matrix used for biclustering.}

\item{threshold}{Only data points higher than this threshold are returned.}
}
\value{
A DataFrame with the frequencies of occurance for values higher 
than a \code{threshold}.
}
\description{
The function uses the \code{\link{occurance_matrix}} function and 
returns all values higher than the \code{threshold} as a DataFrame.
}
\examples{
m <- matrix(seq(1:16), nrow=4)
# m <- matrix(rnorm(10000), nrow=100)
# bics <- c(run_fabia(m), run_isa(m), run_plaid(m))
# occurance_table(bics, m, threshold=.1)

}
