% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{similarity_matrix}
\alias{similarity_matrix}
\title{Compute similarities between biclusters}
\usage{
similarity_matrix(
  bics,
  MARGIN = "both",
  metric = 1L,
  prob_scale = FALSE,
  mat_row = 0L,
  mat_col = 0L,
  prl = FALSE
)
}
\arguments{
\item{bics}{A list of bicluster objects.}

\item{MARGIN}{Choose if the distance is computed over \code{"row"}
, \code{"column"} or \code{"both"}.}

\item{metric}{Integer indicating which metric is used. 
1: Bray-Curtis similarity (default), 2: Jaccard index, 
3: overlap coefficient, 4: Fowlkes–Mallows index.}

\item{prob_scale}{Scale similarity by the probability of an 
overlap equal of higher to the observed one. The scaling is 
done by multiplying the similarity 
with \code{(1 - (1 / (1 - log(overlap_probability, base=100))))}. 
The probability is comupted using the 
function \code{\link{p_overlap_2d_higher}} 
for \code{MARGIN =="both"} and  \code{\link{p_overlap_higher}} 
otherwise. Can be helpful for big imbalances of bicluster sizes.}

\item{mat_row}{If \code{prob_scale == TRUE}, the number of rows of the 
input matrix for biclustering must be given.}

\item{mat_col}{If \code{prob_scale == TRUE}, the number of columns of 
the input matrix for biclustering must be given.}

\item{prl}{Compute the similarity matrix using multiple 
cores (works only for \code{MARGIN="both"}). The number of 
core can be defined by 
executing: \code{RcppParallel::setThreadOptions(numThreads = 4)} 
before running this function.}
}
\value{
A numeric matrix of the similarities between all given biclusters.
}
\description{
This function computes a similarity matrix between biclusters using
different similarity metrics.
}
\examples{
b <- list(bicluster(row=c(1,2,3,4), column=c(1,2,3,4)),
        bicluster(row=c(3,4,5,6), column=c(3,4,5,6)))
similarity_matrix(b)

}
