% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_enrichment.R
\name{run_topGO}
\alias{run_topGO}
\title{Extract functional terms enriched in the DE genes, based on topGO}
\usage{
run_topGO(
  de_container = NULL,
  res_de = NULL,
  de_genes = NULL,
  bg_genes = NULL,
  top_de = NULL,
  FDR_threshold = 0.05,
  min_counts = 0,
  ontology = "BP",
  annot = annFUN.org,
  mapping = "org.Mm.eg.db",
  gene_id = "symbol",
  full_names_in_rows = TRUE,
  add_gene_to_terms = TRUE,
  de_type = "up_and_down",
  topGO_method2 = "elim",
  do_padj = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{de_container}{An object containing the data for a Differential
Expression workflow (e.g. \code{DESeq2}, \code{edgeR} or \code{limma}).
Currently, this can be a \code{DESeqDataSet} object, normally obtained after
running your data through the \code{DESeq2} framework.}

\item{res_de}{An object containing the results of the Differential Expression
analysis workflow (e.g. \code{DESeq2}, \code{edgeR} or \code{limma}).
Currently, this can be a \code{DESeqResults} object created using the \code{DESeq2}
framework.}

\item{de_genes}{A vector of (differentially expressed) genes}

\item{bg_genes}{A vector of background genes, e.g. all (expressed) genes in
the assays}

\item{top_de}{numeric, how many of the top differentially expressed genes to
use for the enrichment analysis.
Attempts to reduce redundancy. Assumes the data is sorted by padj (default
in DESeq2).}

\item{FDR_threshold}{The pvalue threshold to us for counting genes as de.
Default is 0.05}

\item{min_counts}{numeric, min number of counts a gene needs to have to be
included in the geneset that the de genes are compared to. Default is 0,
recommended only for advanced users.}

\item{ontology}{Which Gene Ontology domain to analyze: \code{BP} (Biological
Process), \code{MF} (Molecular Function), or \code{CC} (Cellular Component)}

\item{annot}{Which function to use for annotating genes to GO terms. Defaults
to \code{annFUN.org}}

\item{mapping}{Which \code{org.XX.eg.db} package to use for annotation - select
according to the species}

\item{gene_id}{Which format the genes are provided. Defaults to \code{symbol},
could also be \code{entrez} or \code{ENSEMBL}}

\item{full_names_in_rows}{Logical, whether to display or not the full names
for the GO terms}

\item{add_gene_to_terms}{Logical, whether to add a column with all genes
annotated to each GO term}

\item{de_type}{One of: 'up', 'down', or 'up_and_down' Which genes to use for
GOterm calculations: upregulated, downregulated or both}

\item{topGO_method2}{Character, specifying which of the methods implemented
by \code{topGO} should be used, in addition to the \code{classic} algorithm.
Defaults to \code{elim}.}

\item{do_padj}{Logical, whether to perform the adjustment on the p-values
from the specific topGO method, based on the FDR correction. Defaults to
FALSE, since the assumption of independent hypotheses is somewhat violated
by the intrinsic DAG-structure of the Gene Ontology Terms}

\item{verbose}{Logical, whether to add messages telling the user which steps
were taken}
}
\value{
A table containing the computed GO Terms and related enrichment scores
}
\description{
A wrapper for extracting functional GO terms enriched in the DE genes, based
on the algorithm and the implementation in the topGO package
}
\details{
Allowed values assumed by the \code{topGO_method2} parameter are one of the
following: \code{elim}, \code{weight}, \code{weight01}, \code{lea}, \code{parentchild}.
For more details on this, please refer to the original
documentation of the \code{topGO} package itself
}
\examples{
library("macrophage")
library("DESeq2")
data(gse, package = "macrophage")

dds_macrophage <- DESeqDataSet(gse, design = ~ line + condition)
rownames(dds_macrophage) <- substr(rownames(dds_macrophage), 1, 15)
keep <- rowSums(counts(dds_macrophage) >= 10) >= 6
dds_macrophage <- dds_macrophage[keep, ]
dds_macrophage <- DESeq(dds_macrophage)

data(res_de_macrophage, package = "mosdef")

library("AnnotationDbi")
library("org.Hs.eg.db")
library("topGO")
topgoDE_macrophage <- run_topGO(
  de_container = dds_macrophage,
  res_de = res_macrophage_IFNg_vs_naive,
  ontology = "BP",
  mapping = "org.Hs.eg.db",
  gene_id = "symbol",
)
}
\seealso{
\code{\link[topGO:topGOdata-class]{topGO::topGOdata-class()}} and \code{\link[topGO:getSigGroups]{topGO::runTest()}} for the
class objects and underlying methods

Other Enrichment functions: 
\code{\link{run_cluPro}()},
\code{\link{run_goseq}()}
}
\concept{Enrichment functions}
