% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diffMeth.R
\name{diffMeth}
\alias{diffMeth}
\title{diffMeth}
\usage{
diffMeth(se, cateogory, condition1, condition2,
                 block = NULL, cpmThreshold, thresholdSamples)
}
\arguments{
\item{se}{A RangedSummarizedExperiment containing meta data of the samples.}

\item{cateogory}{The heading name in the sample data to be tested for differential methylation.}

\item{condition1}{The reference group within the cateogory.}

\item{condition2}{The experimental group within the cateogory.}

\item{block}{The heading name in the sample data if differential methylation is to be tested with a blocking factor. Default is NULL.}

\item{cpmThreshold}{Counts per million threshold of read counts to be filtered out of the analysis.}

\item{thresholdSamples}{Minimum number of samples to contain the counts per million threshold.}
}
\value{
A data frame containing which cut sites that are differenitally methylated.
}
\description{
Determines differential methylated sites from a RangedSummarizedExperiment
}
\examples{
# Load data
data(ratdata2)
top <- diffMeth(se = ratdata2, cateogory = "Group",
       condition1 = "Control", condition2 = "Experimental",
       cpmThreshold = 1, thresholdSamples = 1)
}
\author{
Benjamin Mayne
}

