#' prepare_fragpipe
#'
#' Prepare a label free quantification file exported from Fragpipe
#' for subsequent mspms analysis.
#'
#' @param combined_peptide_filepath file path the combined_peptide.tsv file
#' generated by FragPipe.
#' @param colData_filepath file path to .csv file containing colData.
#' Must have columns named "quantCols","group","condition",and "time".
#' @param peptide_library peptide library used with experiment. Contains
#' columns "library_id", "library_match_sequence", and "library_real_sequence".
#' @param n_residues the number of amino acid residues before and after the
#' cleavage site to generate a cleavage seq for.
#'
#' @return a QFeatures object containing a summarizedExperiment named "peptides"
#' @export
#'
#' @examples
#' fragpipe_combined_peptide <- system.file("extdata/fragpipe_combined_peptide.tsv", package = "mspms")
#' colData_filepath <- system.file("extdata/colData.csv", package = "mspms")
#' # Prepare the data
#' fragpipe_prepared_data <- mspms::prepare_fragpipe(fragpipe_combined_peptide, colData_filepath)
prepare_fragpipe <- function(combined_peptide_filepath,
                             colData_filepath,
                             peptide_library = mspms::peptide_library,
                             n_residues = 4) {
  prepared_data <- prepare_file(
    filepath = combined_peptide_filepath,
    colData_filepath = colData_filepath,
    peptide_library = peptide_library,
    n_residues = n_residues,
    read_fun = readr::read_tsv,
    validate_fun = check_file_is_valid_fragpipe,
    transform_fun = transform_fragpipe
  )

  return(prepared_data)
}
