% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_sage.R
\name{prepare_sage}
\alias{prepare_sage}
\title{prepare_sage
Prepare a label free quantification file exported from Sage
for subsequent mspms analysis.}
\usage{
prepare_sage(
  sage_lfq_filepath,
  colData_filepath,
  peptide_library = mspms::peptide_library,
  n_residues = 4
)
}
\arguments{
\item{sage_lfq_filepath}{filepath to lfq.tsv file output from}

\item{colData_filepath}{file path to .csv file containing colData.
Must have columns named "quantCols","group","condition",and "time".}

\item{peptide_library}{peptide library used with experiment. Contains
columns "library_id", "library_match_sequence", and "library_real_sequence".}

\item{n_residues}{the number of amino acid residues before and after the
cleavage site to generate a cleavage seq for.}
}
\value{
a QFeatures object containing a summarizedExperiment named "peptides"
}
\description{
prepare_sage
Prepare a label free quantification file exported from Sage
for subsequent mspms analysis.
}
\examples{
sage_lfq_filepath <- system.file(
  "extdata/sage_lfq.tsv",
  package = "mspms"
)
colData_filepath <- system.file("extdata/colData.csv", package = "mspms")

prepare_sage(sage_lfq_filepath, colData_filepath)
}
