% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/06_find_spacers.R
\name{find_spacers}
\alias{find_spacers}
\title{Find crispr spacers in targetranges}
\usage{
find_spacers(
  gr,
  bsgenome,
  spacer = strrep("N", 20),
  pam = "NGG",
  complement = TRUE,
  ontargetmethod = c("Doench2014", "Doench2016")[1],
  offtargetmethod = c("bowtie", "pdict")[1],
  offtargetfilterby = character(0),
  subtract_targets = FALSE,
  mismatches = 2,
  indexedgenomesdir = INDEXEDGENOMESDIR,
  outdir = OUTDIR,
  verbose = TRUE,
  plot = TRUE,
  ...
)
}
\arguments{
\item{gr}{\code{\link[GenomicRanges]{GRanges-class}}}

\item{bsgenome}{\code{\link[BSgenome]{BSgenome-class}}}

\item{spacer}{string: spacer pattern in extended IUPAC alphabet}

\item{pam}{string: pam pattern in extended IUPAC alphabet}

\item{complement}{TRUE (default) or FALSE: also search in compl ranges?}

\item{ontargetmethod}{'Doench2016','Doench2016' or NULL (no on-target score)}

\item{offtargetmethod}{'bowtie', 'pdict', or NULL (no offtarget analysis)}

\item{offtargetfilterby}{filter for best off-target counts by this variable}

\item{subtract_targets}{TRUE or FALSE (default): whether to subtract target 
(mis)matches from offtarget counts}

\item{mismatches}{0-3: allowed mismatches in offtargetanalysis 
(choose mismatch=-1 to suppress offtarget analysis)}

\item{indexedgenomesdir}{directory with Bowtie-indexed genomes 
(as produced with \code{\link{index_genome}})}

\item{outdir}{directory where bowtie analysis results are written to}

\item{verbose}{TRUE (default) or FALSE}

\item{plot}{TRUE (default) or FALSE}

\item{...}{passed to plot_intervals}
}
\value{
\code{\link[GenomicRanges]{GRanges-class}}
}
\description{
Find crispr spacers in targetranges
}
\examples{
# PE example
#-----------
    require(magrittr)
    bsgenome <- BSgenome.Hsapiens.UCSC.hg38::BSgenome.Hsapiens.UCSC.hg38  
    gr <- char_to_granges(c(PRNP = 'chr20:4699600:+',             # snp
                            HBB  = 'chr11:5227002:-',             # snp
                            HEXA = 'chr15:72346580-72346583:-',   # del
                            CFTR = 'chr7:117559593-117559595:+'), # ins
                          bsgenome)
    plot_intervals(gr)
    find_primespacers(gr, bsgenome)
    find_spacers(extend_for_pe(gr), bsgenome, complement=FALSE, mismatches=0)
          # complement = FALSE because extend_for_pe  already 
          # adds  reverse complements and does so in a strand-specific 
          # manner
    
# TFBS example
#-------------
    bsgenome <- BSgenome.Mmusculus.UCSC.mm10::BSgenome.Mmusculus.UCSC.mm10
    bedfile  <- system.file('extdata/SRF.bed', package='multicrispr')
    gr <- bed_to_granges(bedfile, 'mm10') \%>\% extend()
    gr \%<>\% extract(1:100)
    find_spacers(gr, bsgenome, subtract_targets = TRUE)
}
\seealso{
\code{\link{find_primespacers}} to find prime editing spacers
}
