% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcExprFreqs.R
\name{calcExprFreqs}
\alias{calcExprFreqs}
\title{calcExprFreqs}
\usage{
calcExprFreqs(x, assay = "counts", th = 0)
}
\arguments{
\item{x}{a \code{\link[SingleCellExperiment]{SingleCellExperiment}}.}

\item{assay}{a character string specifying which assay to use.}

\item{th}{numeric threshold value above which
a gene should be considered to be expressed.}
}
\value{
a \code{\link[SingleCellExperiment]{SingleCellExperiment}}
  containing, for each cluster, an assay of dimensions #genes x #samples 
  giving the fraction of cells that express each gene in each sample. 
  If \code{colData(x)} contains a \code{"group_id"} column, the fraction 
  of expressing cells in each each group will be included as well.
}
\description{
Calculates gene expression frequencies
}
\details{
\code{calcExprFreq} computes, for each sample and group (in each cluster),
the fraction of cells that express a given gene. Here, a gene is considered 
to be expressed when the specified measurement value (\code{assay}) 
lies above the specified threshold value (\code{th}).
}
\examples{
data(example_sce)
library(SingleCellExperiment)

frq <- calcExprFreqs(example_sce)

# one assay per cluster
assayNames(frq)  

# expression frequencies by
# sample & group; 1st cluster:
head(assay(frq))

}
\author{
Helena L Crowell & Mark D Robinson
}
