% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pbHeatmap.R
\name{pbHeatmap}
\alias{pbHeatmap}
\title{Heatmap of cluster-sample pseudobulks}
\usage{
pbHeatmap(
  x,
  y,
  k = NULL,
  g = NULL,
  c = NULL,
  top_n = 20,
  fdr = 0.05,
  lfc = 1,
  sort_by = "p_adj.loc",
  decreasing = FALSE,
  assay = "logcounts",
  fun = mean,
  normalize = TRUE,
  col = hcl.colors(10, "viridis"),
  row_anno = TRUE,
  col_anno = TRUE
)
}
\arguments{
\item{x}{a \code{\link[SingleCellExperiment]{SingleCellExperiment}}.}

\item{y}{a list of DS analysis results as returned by 
\code{\link{pbDS}} or \code{\link{mmDS}}.}

\item{k}{character vector; specifies which cluster ID(s) to retain.
Defaults to \code{levels(x$cluster_id)}.}

\item{g}{character vector; specifies which genes to retain.
Defaults to considering all genes.}

\item{c}{character string; specifies which contrast/coefficient to retain.
Defaults to \code{names(y$table)[1]}.}

\item{top_n}{single numeric; number of genes to retain per cluster.}

\item{fdr, lfc}{single numeric; FDR and logFC cutoffs to filter results by.
The specified FDR threshold is applied to \code{p_adj.loc} values.}

\item{sort_by}{character string specifying 
a numeric results table column to sort by;
\code{"none"} to retain original ordering.}

\item{decreasing}{logical; whether to sort 
in decreasing order of \code{sort_by}.}

\item{assay}{character string; specifies which assay to use;
should be one of \code{assayNames(x)}.}

\item{fun}{function to use as summary statistic, 
e.g., mean, median, sum (depending on the input assay).}

\item{normalize}{logical; whether to apply a z-normalization 
to each row (gene) of the cluster-sample pseudobulk data.}

\item{col}{character vector of colors or color mapping function
generated with \code{\link[circlize]{colorRamp2}}. Passed to 
argument \code{col} in \code{\link[ComplexHeatmap]{Heatmap}}
(see \code{?ComplexHeatmap::Heatmap} for details).}

\item{row_anno, col_anno}{logical; whether to render
annotations of cluster and group IDs, respectively.}
}
\value{
a \code{\link{HeatmapList-class}} object.
}
\description{
...
}
\examples{
# compute pseudobulks & run DS analysis
data(example_sce)
pb <- aggregateData(example_sce)
res <- pbDS(pb)

# cluster-sample expression means
pbHeatmap(example_sce, res)

# include only a single cluster
pbHeatmap(example_sce, res, k = "B cells")

# plot specific gene across all clusters
pbHeatmap(example_sce, res, g = "ISG20")

}
\author{
Helena L Crowell
}
