% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_data.R
\name{extract_variants_from_maf}
\alias{extract_variants_from_maf}
\title{Extract variants from a maf object}
\usage{
extract_variants_from_maf(maf, extra_fields = NULL)
}
\arguments{
\item{maf}{MAF object loaded by read.maf() from the 'maftools' package}

\item{extra_fields}{Optionally extract additional columns from the
maf object. Default \code{NULL}.}
}
\value{
Returns a data.table of variants from a maf which can be used to
create a \code{musica} object.
}
\description{
Add description
}
\examples{
maf_file <- system.file("extdata", "public_TCGA.LUSC.maf",
  package = "musicatk"
)
library(maftools)
maf <- read.maf(maf_file)
variants <- extract_variants_from_maf(maf = maf)
}
