% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_musica.R
\name{samp_annot}
\alias{samp_annot}
\alias{samp_annot,musica-method}
\alias{samp_annot<-}
\alias{samp_annot<-,musica,character,vector-method}
\title{Get or set sample annotations from a musica object}
\usage{
samp_annot(object)

\S4method{samp_annot}{musica}(object)

samp_annot(object, name) <- value

\S4method{samp_annot}{musica,character,vector}(object, name) <- value
}
\arguments{
\item{object}{A \code{\linkS4class{musica}} object generated by
the \link{create_musica_from_variants} or \link{create_musica_from_counts}
function.}

\item{name}{The name of the new annotation to add.}

\item{value}{A vector containing the new sample annotations. Needs to be
the same length as the number of samples in the object.}
}
\value{
A new object with the sample annotations added to the table in the
\code{sample_annotations} slot.
}
\description{
Sample annotations can be used to store information about
each sample such as tumor type or treatment status. These are used in
downstream plotting functions such as \code{\link{plot_exposures}} or
\code{\link{plot_umap}} to group or color samples by a particular annotation.
}
\examples{
data(res_annot)
samp_annot(res_annot)

# Add new annotation
samp_annot(res_annot, "New_Annotation") <- rep(c("A", "B"), c(3, 4))
samp_annot(res_annot)
data(musica)
samp_annot(musica, "example") <- rep("ex", 7)
}
\seealso{
See \code{\link{sample_names}} to get a vector of sample names in
the \code{\linkS4class{musica}} object.
}
