% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ndex_groups.R
\name{ndex_group_network_get_permission}
\alias{ndex_group_network_get_permission}
\title{Get Group Permission for a Specific Network}
\usage{
ndex_group_network_get_permission(ndexcon, groupId, networkId)
}
\arguments{
\item{ndexcon}{object of class NDExConnection \link{ndex_connect}}

\item{groupId}{character; unique ID (UUID) of the group}

\item{networkId}{character; unique ID (UUID) of the network}
}
\value{
Network permissions of that group or empty object
}
\description{
Get Group Permission for a Specific Network
}
\note{
Compatible to NDEx server version 2.0
}
\section{REST query}{

GET: ndex_config$api$group$network$get
}

\examples{
## Establish a server connection
ndexcon = ndex_connect()
## Find a group
groups = ndex_find_groups(ndexcon,"Ideker Lab")
groupId = groups[1,"externalId"]
## List networks of the group
networks = ndex_group_list_networks(ndexcon, groupId)
networkId = names(networks)[1]
## Get group's permission to the network
#group = ndex_group_network_get_permission(ndexcon, groupId, networkId)
}
