% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ndex_networks_aspects_and_metadata.r
\name{ndex_network_get_metadata}
\alias{ndex_network_get_metadata}
\title{Get Network CX Metadata Collection}
\usage{
ndex_network_get_metadata(ndexcon, networkId)
}
\arguments{
\item{ndexcon}{object of class NDExConnection link{ndex_connect}}

\item{networkId}{character; unique ID (UUID) of the network}
}
\value{
metadata as list: consistencyGroup, elementCount, lastUpdate, name, properties, version and idCounter
}
\description{
This function retrieves the (aspect) meta-data of the network identified by the supplied network UUID string.
}
\details{
\strong{Note: In future `ndexr` uses the \link[RCX]{RCX-object} from the corresponding package to handle the networks!}
\strong{See also \link[RCX]{Meta-data} for more information.}
}
\note{
Compatible to NDEx server version 1.3 and 2.0, but doesn't work for version 1.3
}
\section{REST query}{

GET: ndex_config$api$network$aspect$getMetaData
}

\examples{
## Establish a server connection
ndexcon = ndex_connect()
## Find a network and get its UUID
networks = ndex_find_networks(ndexcon,"p53", "nci-pid")
networkId = networks[1,"externalId"]
## Get the network meta-data
ndex_network_get_metadata(ndexcon, networkId) 
}
