% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ndex_networks_ndex_properties.r
\name{ndex_network_get_permission}
\alias{ndex_network_get_permission}
\title{Get All Permissions on a Network}
\usage{
ndex_network_get_permission(ndexcon, networkId, type, permission, start, size)
}
\arguments{
\item{ndexcon}{object of class NDExConnection link{ndex_connect}}

\item{networkId}{unique ID of the network}

\item{type}{character ("user"|"group"); specifies whether user or group permissions should be returned}

\item{permission}{character (optional)("READ"|"WRITE"|"ADMIN"); constrains the type of the returned membership. If not set (or NULL), all permission types will be returned.}

\item{start}{integer (optional); specifies that the result is the nth page of the requested data.}

\item{size}{integer (optional); specifies the number of data items in each page.}
}
\value{
data.frame containing user or group UUIDs and the highest permission assigned to that user or group
}
\description{
This function retrieves the user or group permissions for a network
}
\note{
Compatible to NDEx server version 1.3 and 2.0

In version 1.3 the function only returns user permissions and differs in the returned data (more columns)!

Requires an authorized user! (ndex_connect with credentials)
}
\section{REST query}{

GET: ndex_config$api$network$permission$get
}

\examples{
## Establish a server connection with credentials 
# ndexcon = ndex_connect('MyAccountName', 'MyPassword')
## Find one of your networks and get its UUID
# networks = ndex_find_networks(ndexcon, accountName='MyAccountName')
# networkId = networks[1,"externalId"]
## Get the permissions
# permissions = ndex_network_get_permission(ndexcon, networkId, 'user')
## Version 2.0:
## names(permission)
## [1] "memberUUID" "permission"
## Version 1.3:
## names(permission)
## [1] "membershipType"    "memberUUID"  "resourceUUID"      
## [4] "memberAccountName" "permissions" "resourceName" 
# permissions = ndex_network_get_permission(ndexcon, networkId, 'user', NULL)    # same as previous
# permissions = ndex_network_get_permission(ndexcon, networkId, 'user', 'READ', 0, 10)
# permissions = ndex_network_get_permission(ndexcon, networkId, 'group')
NULL
}
