% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ndex_connect.r
\name{ndex_rest_GET}
\alias{ndex_rest_GET}
\title{Generic GET query to API.}
\usage{
ndex_rest_GET(ndexcon, route, raw = FALSE)
}
\arguments{
\item{ndexcon}{object of class NDExConnection \code{\link{ndex_connect}}}

\item{route}{Character (route to specific REST query)}

\item{raw}{Specifies if server response should be returned in raw, or if jsonlite::fromJSON is called first. Defaults to FALSE.}
}
\value{
JSON response from REST server, NULL if no valid JSON was received. if parameter raw is TRUE, the raw response is returned without a call to jsonlite::fromJSON.
}
\description{
Generic GET query to API.
}
\details{
Simply execute HTTP GET on URL host/route and fetch whatever data REST server returns 
Making sure the route is well-formed is the job of calling function
}
\note{
This function is internal.
}
\examples{
## Establish a server connection
ndexcon = ndex_connect()
\dontrun{
ndex_rest_GET(ndexcon, "/networks/api")
}
}
\seealso{
\code{\link{ndex_rest_GET}},  \code{\link{ndex_rest_POST}},  \code{\link{ndex_rest_PUT}} and \code{\link{ndex_rest_DELETE}}
}
\keyword{internal}
