% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ndex_groups.R
\name{ndex_update_group}
\alias{ndex_update_group}
\title{Update Group}
\usage{
ndex_update_group(
  ndexcon,
  groupId,
  groupName,
  image,
  website,
  description,
  properties
)
}
\arguments{
\item{ndexcon}{object of class NDExConnection link{ndex_connect}}

\item{groupId}{character; unique ID (UUID) of the group}

\item{groupName}{character; name of the new graoup}

\item{image}{character (optional); URL of the account owner's image.}

\item{website}{character (optional); URL of the account owner's web site}

\item{description}{character (optional); Short description of this user.}

\item{properties}{list (optional); additional properties for the group}
}
\value{
Empty string ("") on success, else error
}
\description{
Updates the group based on the data.
}
\note{
Requires an authorized user! (ndex_connect with credentials)

Compatible to NDEx server version 2.0
}
\section{REST query}{

PUT: ndex_config$api$user$update
}

\examples{
## Establish a server connection with credentials 
# ndexcon = ndex_connect('MyAccountName', 'MyPassword')
## Find user and get its id
# user = ndex_find_user_byName(ndexcon, 'MyAccountName')
# userId = user$externalId
## Find the user's groups and get one group id
# groups = ndex_user_list_groups(ndexcon, userId)
# groupId = groups[1,"externalId"]
## Update the group
# ndex_update_group(ndexcon, groupId, description='A really nice group!')
NULL
}
