% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ndex_users.R
\name{ndex_update_user}
\alias{ndex_update_user}
\title{Update User}
\usage{
ndex_update_user(
  ndexcon,
  userId,
  emailAddress,
  isIndividual,
  displayName,
  firstName,
  lastName,
  image,
  website,
  description,
  verbose = FALSE
)
}
\arguments{
\item{ndexcon}{object of class NDExConnection link{ndex_connect}}

\item{userId}{character; unique ID of the user}

\item{emailAddress}{character (optional); email address (used for verification if enabled)}

\item{isIndividual}{boolean (default:True); True if this account is for an individual user. False means this account is for an organization or a project etc.}

\item{displayName}{character (optional); Display name of this account, only applied to non-individual accounts.}

\item{firstName}{character (optional); Account owner's first name, only applies to individual accounts.}

\item{lastName}{character (optional); Account owner's last name, only appliies to individual accounts.}

\item{image}{character (optional); URL of the account owner's image.}

\item{website}{character (optional); URL of the account owner's web site}

\item{description}{character (optional); Short description of this user.}

\item{verbose}{logical (optional); whether to print out extended feedback}
}
\value{
Empty string ("") on success, else error
}
\description{
Updates the authenticated user based on the data. Errors, if the user for ndexcon and uuid are different.
}
\note{
Requires an authorized user! (ndex_connect with credentials)

Compatible to NDEx server version 2.0
}
\section{REST query}{

GET: ndex_config$api$user$update
}

\examples{
## Establish a server connection with credentials 
# ndexcon = ndex_connect('MyAccountName', 'MyPassword')
## Find user and get its id
# user = ndex_find_user_byName(ndexcon, 'SomeUserName')
# userId = user$externalId
## Update user
# ndex_update_user(ndexcon, userId, firstName = 'Homer Jay', lastName = 'Simpson')
# ndex_update_user(ndexcon, userId, displayName = 'Max Power', 
#                  image='https://upload.wikimedia.org/wikipedia/en/0/02/Homer_Simpson_2006.png', 
#                  description='One of the most influential characters in the history of TV')
NULL
}
