% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ndex_users.R
\name{ndex_user_get_showcase}
\alias{ndex_user_get_showcase}
\title{Get User's Showcase Networks}
\usage{
ndex_user_get_showcase(ndexcon, userId)
}
\arguments{
\item{ndexcon}{object of class NDExConnection link{ndex_connect}}

\item{userId}{character; unique ID (UUID) of the user}
}
\value{
data.frame of networks (name, description, externalId, uri, etc.) in the showcase of the specified user
}
\description{
This is a convenience function to support "user pages" in NDEx applications. 
This function returns a list of network summary objects that the user who is specified by userid chose to display in his or her home page. 
For authenticated users, this function returns the networks that the authenticated user can read, for anonymous users, this function returns only public networks.
}
\note{
Compatible to NDEx server version 2.0
}
\section{REST query}{

GET: ndex_config$api$user$showcase
}

\examples{
## Establish a server connection
ndexcon = ndex_connect()
## get user by name to get UUID
user = ndex_find_user_byName(ndexcon, 'ndextutorials')
userId = user$externalId
## get all network permissions of the user
showcase = ndex_user_get_showcase(ndexcon, userId)
names(showcase)
## [1] "ownerUUID"    "isReadOnly"  "subnetworkIds"  "errorMessage"      "isValid"         
## [6] "warnings"     "isShowcase"  "visibility"     "edgeCount"         "nodeCount"       
##[11] "uri"          "version"     "owner"          "name"              "properties"      
##[16] "description"  "externalId"  "isDeleted"      "modificationTime"  "creationTime"
}
