% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ndex_users.R
\name{ndex_user_mail_password}
\alias{ndex_user_mail_password}
\title{Email New Password}
\usage{
ndex_user_mail_password(ndexcon, userId)
}
\arguments{
\item{ndexcon}{object of class NDExConnection link{ndex_connect}}

\item{userId}{character; unique ID of the user}
}
\value{
Empty string on success, else error
}
\description{
Causes a new password to be generated for the given user account and then emailed to the user's emailAddress
}
\note{
Compatible to NDEx server version 2.0
}
\section{REST query}{

GET: ndex_config$api$user$password$mail
}

\examples{
## Establish a server connection
# ndexcon = ndex_connect()
## Find user and get its id
# user = ndex_find_user_byName(ndexcon, 'SomeUserName')
# userId = user$externalId
## Request new password via email
# ndex_user_mail_password(ndexcon, userId)
NULL
}
