% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NetResponseModel-accessors.R
\name{get.subnets,NetResponseModel-method}
\alias{get.subnets,NetResponseModel-method}
\alias{get.subnets}
\title{get.subnets}
\usage{
\S4method{get.subnets}{NetResponseModel}(
  model,
  get.names = TRUE,
  min.size = 2,
  max.size = Inf,
  min.responses = 2
)
}
\arguments{
\item{model}{Output from the detect.responses function. An object of
NetResponseModel class.}

\item{get.names}{Logical. Indicate whether to return subnetwork nodes using
node names (TRUE) or node indices (FALSE).}

\item{min.size, max.size}{Numeric. Filter out subnetworks whose size is not
within the limits specified here.}

\item{min.responses}{Numeric. Filter out subnetworks with less responses
(mixture components) than specified here.}
}
\value{
A list of subnetworks.
}
\description{
List the detected subnetworks (each is a list of nodes in the corresponding
subnetwork).
}
\examples{
## Load a pre-calculated netresponse model obtained with 
# model <- detect.responses(toydata$emat, toydata$netw, verbose = FALSE)
# data( toydata ); get.subnets(toydata$model) 
}
\references{
Leo Lahti et al.: Global modeling of transcriptional responses
in interaction networks. Bioinformatics (2010).  See citation('netresponse')
for details.
}
\author{
Leo Lahti \email{leo.lahti@iki.fi}
}
\keyword{utilities}
