% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FastqcFile.R
\docType{class}
\name{.FastqcFile-class}
\alias{.FastqcFile-class}
\title{The .FastqcFile Object Class}
\arguments{
\item{x}{character(1) denoting a file.path}
}
\value{
An object of class .FastqcFile
}
\description{
The .FastqcFile Object Class defines a path to the output from
the standalone tool FastQC.
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
}
\details{
This class simply refers to a fastqc output file after checking for
existence and validity (i.e. the correct internal structure).
Underlying files can be zipped (*_fastqc.zip) or extracted directories

The helper function \code{.FastqcFile()} is a simple constructor which
checks validity and enables construction of other dependent classes.
}
\section{Slots}{

\describe{
\item{\code{path}}{Character vector of length 1 which contains a valid file path.}
}}

\examples{

# Get the files included with the package
packageDir <- system.file("extdata", package = "ngsReports")
fl <- list.files(packageDir, pattern = "fastqc.zip", full.names = TRUE)[1]

# As this is the root structure, we can only call this
# function with an individual file
ff <- ngsReports:::.FastqcFile(fl)

}
\keyword{internal}
