% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotAdapterContent.R
\docType{methods}
\name{plotAdapterContent}
\alias{plotAdapterContent}
\alias{plotAdapterContent,ANY-method}
\alias{plotAdapterContent,FastqcData-method}
\alias{plotAdapterContent,FastqcDataList-method}
\alias{plotAdapterContent,FastpData-method}
\alias{plotAdapterContent,FastpDataList-method}
\title{Draw an Adapter Content Plot}
\usage{
plotAdapterContent(
  x,
  usePlotly = FALSE,
  labels,
  pattern = ".(fast|fq|bam).*",
  ...
)

\S4method{plotAdapterContent}{ANY}(
  x,
  usePlotly = FALSE,
  labels,
  pattern = ".(fast|fq|bam).*",
  ...
)

\S4method{plotAdapterContent}{FastqcData}(
  x,
  usePlotly = FALSE,
  labels,
  pattern = ".(fast|fq|bam).*",
  pwfCols,
  showPwf = TRUE,
  warn = 5,
  fail = 10,
  scaleColour = NULL,
  plotlyLegend = FALSE,
  ...
)

\S4method{plotAdapterContent}{FastqcDataList}(
  x,
  usePlotly = FALSE,
  labels,
  pattern = ".(fast|fq|bam).*",
  pwfCols,
  showPwf = TRUE,
  warn = 5,
  fail = 10,
  plotType = c("heatmap", "line"),
  adapterType = "Total",
  cluster = FALSE,
  dendrogram = FALSE,
  heat_w = 8L,
  scaleFill = NULL,
  scaleColour = NULL,
  plotlyLegend = FALSE,
  ...
)

\S4method{plotAdapterContent}{FastpData}(
  x,
  usePlotly = FALSE,
  labels,
  pattern = ".(fast|fq|bam).*",
  scaleFill = NULL,
  plotlyLegend = FALSE,
  plotTheme = theme_get(),
  ...
)

\S4method{plotAdapterContent}{FastpDataList}(
  x,
  usePlotly = FALSE,
  labels,
  pattern = ".(fast|fq|bam).*",
  pwfCols,
  showPwf = FALSE,
  warn = 5,
  fail = 10,
  cluster = FALSE,
  dendrogram = FALSE,
  scaleFill = NULL,
  plotTheme = theme_get(),
  heat_w = 8L,
  ...
)
}
\arguments{
\item{x}{Can be a \code{FastqcData}, a \code{FastqcDataList} or character
vector of file paths}

\item{usePlotly}{\code{logical}. Output as ggplot2 (default) or plotly
object.}

\item{labels}{An optional named vector of labels for the file names.
All filenames must be present in the names.}

\item{pattern}{regex used to trim the ends of all filenames for plotting}

\item{...}{Used to pass additional attributes to theme() for FastQC objects
and geoms for Fastp objects}

\item{pwfCols}{Object of class \code{\link[=PwfCols]{PwfCols()}} containing the colours
for PASS/WARN/FAIL}

\item{showPwf}{logical(1) Show PASS/WARN/FAIL status as would be included in
a standard FastQC report}

\item{warn, fail}{The default values for warn and fail are 5 and 10
respectively (i.e. percentages)}

\item{plotlyLegend}{logical(1) Show legend when choosing interactive plots.
Ignored for heatmaps}

\item{plotType}{\code{character}. Can only take the values
\code{plotType = "heatmap"} or \code{plotType = "line"}}

\item{adapterType}{A regular expression matching the adapter(s) to be
plotted. To plot all adapters summed, specify \code{adapterType = "Total"}.
This is the default behaviour.}

\item{cluster}{\code{logical} default \code{FALSE}. If set to \code{TRUE},
fastqc data will be clustered using hierarchical clustering}

\item{dendrogram}{\code{logical} redundant if \code{cluster} is \code{FALSE}
if both \code{cluster} and \code{dendrogram} are specified as \code{TRUE}
then the dendrogram will be displayed.}

\item{heat_w}{Width of the heatmap relative to other plot components}

\item{scaleFill, scaleColour}{scale_fill\* and scale_colour_\* objects}

\item{plotTheme}{Set theme elements by passing a \link[ggplot2]{theme}}
}
\value{
A standard ggplot2 object, or an interactive plotly object
}
\description{
Draw an Adapter Content Plot across one or more FASTQC reports
}
\details{
This extracts the Adapter_Content module from the supplied object and
generates a ggplot2 object, with a set of minimal defaults.
The output of this function can be further modified using the standard
ggplot2 methods.

When \code{x} is a single or FastqcData object line plots will always be
drawn for all adapters.
Otherwise, users can select line plots or heatmaps.
When plotting more than one fastqc file, any undetected adapters will not be
shown.

An interactive version of the plot can be made by setting \code{usePlotly}
as \code{TRUE}
}
\examples{

# Get the files included with the package
packageDir <- system.file("extdata", package = "ngsReports")
fl <- list.files(packageDir, pattern = "fastqc.zip", full.names = TRUE)

# Load the FASTQC data as a FastqcDataList object
fdl <- FastqcDataList(fl)

# The default plot
plotAdapterContent(fdl)

# Also subset the reads to just the R1 files
r1 <- grepl("R1", fqName(fdl))
plotAdapterContent(fdl[r1])

# Plot just the Universal Adapter
# and change the y-axis using ggplot2::scale_y_continuous
plotAdapterContent(fdl, adapterType ="Illumina_Universal", plotType = "line") +
facet_wrap(~Filename) +
guides(colour = "none")

# For FastpData object, the plots are slightly different
fp <- FastpData(system.file("extdata/fastp.json.gz", package = "ngsReports"))
plotAdapterContent(fp, scaleFill = scale_fill_brewer(palette = "Set1"))

}
