## ----echo = FALSE-------------------------------------------------------------
library(knitr)

## ----eval=FALSE---------------------------------------------------------------
# if(!requireNamespace("sgdGMF", quietly = TRUE))
#     install.packages("sgdGMF")
# 
# BiocManager::install("omicsGMF")
# 

## ----echo = TRUE, warning=FALSE, message=FALSE--------------------------------
library(sgdGMF)
library(omicsGMF)
library(dplyr)
library(scuttle)
set.seed(100)

## -----------------------------------------------------------------------------
example_sce <- mockSCE(ncells = 20, ngenes = 50)

X <- model.matrix(~Treatment, colData(example_sce))

## -----------------------------------------------------------------------------
example_sce <- runCVGMF(
    example_sce, 
    X = X,                   # Covariate matrix
    exprs_values = "counts", # Use raw counts (no normalization)
    family = poisson(),      # Poisson model for RNA-seq count data
    ncomponents = 1:5,       # Test components from 1 to 5
    ntop = 50               # Use top 50 most variable genes
)             

metadata(example_sce)$cv_GMF %>% 
    group_by(ncomp) %>% 
    summarise(mean_dev = mean(dev),
              mean_aic = mean(aic),
              mean_bic = mean(bic),
              mean_mae = mean(mae),
              mean_mse = mean(mse))

plotCV(example_sce, name = "cv_GMF")


## -----------------------------------------------------------------------------
example_sce <- runRankGMF(
    example_sce, 
    X = X, 
    exprs_values="counts", 
    family = poisson(), 
    maxcomp = 10,
    ntop = 50)

plotRank(example_sce, maxcomp = 10)

## -----------------------------------------------------------------------------
example_sce <- runGMF(
    example_sce, 
    X = X, 
    exprs_values="counts", 
    family = poisson(), 
    ncomponents = 3, # Use optimal dimensionality, here arbitrarily chosen as 3
    ntop = 50,
    name = "GMF")

## ----results = 'hide'---------------------------------------------------------
reducedDimNames(example_sce)
head(reducedDim(example_sce))

names(attributes(reducedDim(example_sce, type = "GMF")))
head(attr(reducedDim(example_sce, type = "GMF"), "rotation"))
tail(attr(reducedDim(example_sce, type = "GMF"), "trace"))


## -----------------------------------------------------------------------------
plotReducedDim(example_sce, dimred = "GMF", colour_by = "Mutation_Status")

## -----------------------------------------------------------------------------
sessionInfo()

