getSearchCols <- function(x) {
  if (is.null(x))
    return(NULL)
  lapply(x$columns, "[[", "search")
}

getOrderCols <- function(x) {
  if (is.null(x))
    return(NULL)
  x[["order"]]
}

null2empty <- function(x) {
  if (is.null(x))
    return("")
  x
}

exprsImpute <- function(x) { 
    v <- try(x@assayData$exprs_impute, silent = TRUE)
    if (inherits(v, "try-error")) 
      v <- NULL
    v
}


#' Generating k distinct colors
#' @description Mainly used in the shiny app to generate reproducible k distinct colors. 
#' @param k a number between 1 to 60 tells how many distinct colors to use
#' @param stop logical; whether the function should return an error message if
#'   k is not in the range of 2 to 60. Default FALSE, the function will return NULL. 
#' @return a vector of hex code for k colors or NULL
#' @examples 
#' nColors(5)
#' nColors(1, stop = FALSE)
#' @export

nColors <- function(k, stop = FALSE) {

  k <- as.integer(k)  
  if (!is.integer(k) || k > 60 || k < 1 || is.na(k)) {
    if (stop) 
      stop("k should be an integer between 1 and 60!") else
        return(NULL)
  }
  
  l <- list(
    c('#B5D3A2'),
    c('#C07CCA', '#B5D3A2'),
    c('#B0C8C8', '#C470C8', '#B6D778'),
    c('#9FD2D2', '#D8949E', '#B86BD9', '#B5DA77'),
    c('#DBBC74', '#B859DB', '#C792BF', '#96E37D', '#A0D6D1'),
    c('#BD55D9', '#B19CD7', '#D8CC6A', '#A8D7CF', '#87E285', '#DC8085'),
    c('#BD55DA', '#B198D5', '#C1DD57', '#DF6D83', '#9ED3DA', '#83E2A3', '#D8C093'),
    c('#B18DD2', '#7BE398', '#CFCF9A', '#7FD1D9', '#C8D851', '#BE51DB', '#D6C8CE', '#DB6F72'),
    c('#80D4DC', '#92E464', '#D6D0B7', '#B947DE', '#DBC85C', '#8AE0A8', '#ACA6D5', '#C17BD0', '#DD7377'),
    c('#CAD399', '#D888C6', '#7FDFC8', '#7F78D6', '#DACBC9', '#DBD14F', '#BE48DE', '#88B5D7', '#DE7665', '#83E474'),
    c('#DAD85A', '#D977CB', '#85C6D8', '#7D81D6', '#D19A66', '#77E1BE', '#DC5F73', '#B947E1', '#D3DEBA', '#86E271', '#D1AFCD'),
    c('#CAA7D0', '#D19965', '#DC6073', '#BA47E2', '#DBD650', '#D974C9', '#82E46F', '#7EC3D8', '#DADACC', '#C6DB99', '#7AE2C2', '#787ED6'),
    c('#8EE261', '#CFDFAA', '#DBCECE', '#76E0A4', '#DCD554', '#D19962', '#7FDCDA', '#DA5DD0', '#A344EA', '#7A74D3', '#DB6077', '#D39AD3', '#7FA9CF'),
    c('#D39756', '#DA5DD0', '#7873D2', '#CCE1D1', '#A344EA', '#DAD84F', '#D39AD4', '#D0D997', '#84ADD2', '#DA5E75', '#D8B5B4', '#86E367', '#78DEA6', '#71DDDF'),
    c('#DB47D3', '#7877D4', '#D2AED5', '#74E1A5', '#7CADD2', '#E0D250', '#D06692', '#D3DCD0', '#75DDDC', '#8FE25F', '#E4665A', '#DA85DB', '#CBDD9E', '#CA9B71', '#9545E8'),
    c('#9DE153', '#83DDB1', '#CDDB98', '#69E788', '#D4E2D6', '#DB49D3', '#9645E8', '#DD5F73', '#72DCE0', '#7777D5', '#D69A54', '#DED650', '#D1ABD7', '#7CACD2', '#D77ECE', '#CCA69A'),
    c('#C3DCC5', '#DFD99D', '#AFDE88', '#E65566', '#D5A2E1', '#79D8E2', '#A144EA', '#CA729F', '#CA9781', '#DC5DD3', '#73E268', '#71DFB4', '#7BA3CF', '#7871D2', '#D99E49', '#DDCEDB', '#D8DC50'),
    c('#8861D8', '#77E5D7', '#D1B0D9', '#9939EC', '#82C4DE', '#78E8A0', '#D7DB51', '#759E77', '#85E15B', '#DC47D3', '#DC88DD', '#D06593', '#DE695B', '#738AD2', '#D5E3D7', '#D4E3A3', '#D9A755', '#D6AC9F'),
    c('#A343EC', '#869BD8', '#BDE6CF', '#E09C48', '#E0576E', '#68E3D9', '#BBE68E', '#DBDA50', '#83CAE2', '#6DE4A2', '#79938B', '#7CE056', '#DCC9DC', '#7F68CD', '#D8978A', '#AEAC6B', '#D68ECC', '#E7E0B8', '#DE58D2'),
    c('#7DE2B2', '#DF7FD1', '#85C5DF', '#91E144', '#CCA1D3', '#9745EB', '#6AE1DD', '#AFE086', '#DC5C72', '#809474', '#DC47D2', '#E1D999', '#DED750', '#6C95D5', '#8168CB', '#D9964F', '#DED9E4', '#5AE888', '#D9A99E', '#CDE5CA'),
    c('#D3D8E5', '#76D9E3', '#DF7FD5', '#DEB2A9', '#E9556A', '#B96B8C', '#9645E9', '#7873D4', '#D7E74F', '#DEC44E', '#809874', '#D2A9DF', '#79DC4C', '#E3DC9E', '#CCE6CC', '#60EB94', '#77A4D0', '#DB47D2', '#D49057', '#78E3BC', '#B1E289'),
    c('#D1E199', '#DCDB50', '#DCAA4E', '#66E688', '#769B76', '#6C95D4', '#8B45E8', '#CDA9DC', '#B76F8D', '#D5A184', '#87C5DF', '#DFCED7', '#6BE1DD', '#D74DC5', '#D0E4CC', '#E56250', '#7E6BD0', '#97E254', '#DF89DC', '#83E6B6', '#EA5B8C', '#DE48EE'),
    c('#D9E3DB', '#E09852', '#DE89DB', '#A69A65', '#D6B1DD', '#7D6ACF', '#DEAFA6', '#6EA485', '#94B5D2', '#DED84F', '#8E47E8', '#E9576A', '#B0EBC0', '#E5E0A5', '#64EA9A', '#D84DC2', '#76D1E3', '#E147EE', '#B86A8B', '#ACDC7D', '#83E14D', '#67E8D7', '#7095DA'),
    c('#83CBE5', '#B4E78F', '#7CE758', '#E8649E', '#7D95AD', '#BDE9CA', '#DAD8E3', '#6A90DD', '#7BA27A', '#D69D4D', '#E4DAC1', '#DFDB4C', '#DE86DD', '#E3DC96', '#6BE9A6', '#8565D2', '#6AE4DB', '#A56386', '#963FEC', '#D1AADC', '#D79D8F', '#E8605A', '#85B741', '#DB48D5'),
    c('#DFB8B1', '#DE9A3D', '#DDD8E9', '#DC46D2', '#558F44', '#859B8A', '#7397D3', '#E080D7', '#59DF52', '#9745EA', '#E3DB50', '#60EB95', '#81E2B4', '#ABE64C', '#E1E1A8', '#D18E6E', '#7C6DD0', '#E9556A', '#CABB67', '#83C7E0', '#BE6E94', '#B2E388', '#6AE3DF', '#CCE7D0', '#D2A9DF'),
    c('#DB7EDB', '#E55760', '#DC46D3', '#E2D647', '#6E99DD', '#DAE2DE', '#9645E9', '#7EAF41', '#E4E1B2', '#D06996', '#D9C4E1', '#DCC675', '#74A17C', '#5BE986', '#BEEF66', '#B7E493', '#B9E7C9', '#69E1DD', '#76E8B5', '#7A6BCD', '#76E137', '#D98E4A', '#D5A4DE', '#8B839B', '#D7A89A', '#85C7E1'),
    c('#D76FD6', '#D2B6DC', '#7C9C9F', '#ACE083', '#D7A89F', '#E4615B', '#9631EB', '#E145DB', '#E2DC8B', '#C57496', '#B1E850', '#6993DC', '#7C5DAC', '#749D6B', '#D89A52', '#82C8E6', '#D5E5E5', '#61EB93', '#D69BE5', '#8862E5', '#E8569C', '#78E7B7', '#E0D6B3', '#6BE2DE', '#DDD346', '#57DD51', '#BFE9C3'),
    c('#D97ADC', '#E3DD9B', '#80CAE1', '#905DE2', '#E8605D', '#E597CE', '#78E04B', '#778698', '#D6E4E3', '#7CE2B2', '#D8EA51', '#6283E6', '#DF45D7', '#D89652', '#825BA7', '#6AE3DE', '#74A2DC', '#DC5793', '#C3A4E3', '#952FEB', '#C17986', '#DAC3E1', '#DBC64B', '#859A71', '#ACDE81', '#E0B8A9', '#C7E6C3', '#5DEB92'),
    c('#DF47EE', '#DFC574', '#DDDA4C', '#D643BE', '#8BE33D', '#67E4DF', '#82CCE3', '#D9923D', '#5AE784', '#CAE69E', '#E699BF', '#70A0DE', '#78E8B4', '#7278D5', '#955ED8', '#C5A3E2', '#8539EA', '#DBE1E1', '#E75E5B', '#8292A3', '#A45C7F', '#A6DF72', '#759F75', '#E85691', '#D39D89', '#E2D9B6', '#DBC3E0', '#E083DA', '#B8E7CA'),
    c('#996586', '#D7DC65', '#5BE57F', '#DF5993', '#D69C89', '#DF9A48', '#DD83DC', '#C0E4D7', '#E79ABF', '#BDECB8', '#76A1A4', '#CDA9E5', '#E4DCC2', '#A6DE7C', '#65A680', '#E0CFDD', '#83D1E9', '#D94BCB', '#E75D5C', '#E9E09C', '#96E542', '#7D6BD0', '#5D90D8', '#72E8B5', '#E3D43A', '#67E5E0', '#D337EF', '#A6A366', '#98B3DD', '#8B49E7'),
    c('#7377E8', '#E35F9B', '#E1BDDE', '#C7E6C6', '#DD99E2', '#D8E5E5', '#DA8F70', '#E95A5C', '#91E43B', '#E3D84A', '#6294DA', '#E241DA', '#9544EA', '#7D56A6', '#DF9C41', '#D66CD7', '#A9A170', '#ADE39C', '#BEEE7C', '#61AA84', '#5BE57F', '#6CEADF', '#E0BBAF', '#84C0E4', '#AD9FD5', '#B7708B', '#9BB44E', '#78D4E1', '#72E8B5', '#7C969D', '#EBE29E'),
    c('#E3E3CB', '#7DEAB0', '#716AD6', '#E9E19B', '#839494', '#62A982', '#7BBFE2', '#5BE783', '#CD6CD8', '#DCED53', '#A6A366', '#D498E4', '#E598C1', '#D98E70', '#8F40EA', '#B15B7E', '#C7B1E1', '#BDEABF', '#B2DADE', '#E3D7E9', '#8171A5', '#AADE7B', '#83E240', '#6898E1', '#5FE7D1', '#6FDDE2', '#E044DB', '#DE9942', '#DDB4AB', '#EB5AA4', '#D7C747', '#E8595D'),
    c('#83C3E4', '#7D50DA', '#E2E0BC', '#58E88E', '#D69BE5', '#D437B6', '#DCDFE9', '#E95169', '#E14EED', '#912DEC', '#A1AD6A', '#D5D960', '#5AC397', '#E677D0', '#DA876E', '#BCE6CF', '#63EDDC', '#A9E174', '#EDE397', '#7E9C98', '#7B96CD', '#E2B6B3', '#A5EBAE', '#667CD7', '#D9B1DB', '#BE6D94', '#D2ED41', '#76D9E1', '#E3C73B', '#B49976', '#76E348', '#A76CD8', '#DF9A46'),
    c('#98A880', '#83E639', '#599044', '#5AE169', '#805AA5', '#7B8697', '#D6E5E6', '#DFC3BA', '#902EEA', '#E5E6BB', '#DAE64D', '#E59B96', '#6BE9E6', '#E7DD89', '#E292C3', '#ACE470', '#77A0DB', '#EA5769', '#E045DD', '#83C9E3', '#64BBAD', '#DE69CA', '#5EEA97', '#B6E7C8', '#D29DEB', '#B3E397', '#5C83E6', '#B35E80', '#DCBF42', '#D2BAE0', '#935FE2', '#DC9152', '#B79A6E', '#77E6B7'),
    c('#DFACA7', '#AFE687', '#78E8B8', '#E180DF', '#985CEB', '#E6A1DA', '#BE9E6B', '#912AEA', '#5CA175', '#57E356', '#5F6FD9', '#B6E8C3', '#A2E648', '#D0BCE0', '#DD9346', '#E8635E', '#60EB93', '#81C8E5', '#66E1DE', '#E5D57D', '#A487D2', '#E5DEBD', '#B3DBD8', '#E75898', '#E246DC', '#DDC43F', '#929E86', '#B56889', '#6B99DD', '#7BAD3D', '#E8E9EB', '#E4EC55', '#A048B2', '#788A9E', '#D2E5A3'),
    c('#CC7293', '#EAE19A', '#E95A5C', '#BCE9C0', '#DF78E0', '#7E9591', '#985BE4', '#A48CAF', '#925E56', '#E4E3CA', '#5BE680', '#ACE081', '#8431EA', '#A7BAEA', '#5BAA84', '#D33DBB', '#DDAFA4', '#E95595', '#6DD4DC', '#5D92D8', '#D9DC4F', '#71BFDF', '#76E8B2', '#E18DD4', '#E3AF3C', '#A7A567', '#5974E5', '#E146EF', '#7D56A4', '#DF915E', '#B996E7', '#69EDE1', '#92E442', '#E2B2E1', '#B4DCE1', '#E6D7E5'),
    c('#60B94B', '#7BE533', '#97A46F', '#E3DFBE', '#A05A7D', '#962DEB', '#5EE8D3', '#DF44D7', '#E793C5', '#71DDE2', '#E4AD3A', '#B7E6C6', '#80EBB3', '#DBD565', '#E95A5C', '#D3B172', '#E5EBA9', '#AFD6DF', '#6595DA', '#9659E3', '#746ED0', '#7C9491', '#DBC4E6', '#E65393', '#D79489', '#D1A4EC', '#B2E766', '#A593B9', '#EAEFED', '#B1E390', '#DDBBB5', '#D88752', '#5AED8C', '#DFE13D', '#D675D6', '#7ABFE3', '#54AC85'),
    c('#E2CFBD', '#B9A2DF', '#9559E3', '#748CA2', '#814E6C', '#902DEB', '#DD7FDF', '#DFD944', '#C1F174', '#E6DC88', '#DFA342', '#B1E394', '#9ECCE9', '#6597DD', '#D9C2DF', '#94EDB8', '#CF739F', '#61C1DD', '#EBA6E0', '#81B53F', '#A5A167', '#5BEACC', '#DEE9EA', '#70E2E4', '#DD8D70', '#DAA8A3', '#5573E5', '#58AE83', '#E4543D', '#5BEA8A', '#E4E7B9', '#8FA99B', '#E44DEB', '#EA547C', '#BBE7CD', '#D33DB4', '#83E539', '#8A69BF'),
    c('#D643BF', '#9AB9E4', '#D89078', '#B6D8D3', '#7C918C', '#E1DCBA', '#DFC5E5', '#A38CB0', '#5E91D7', '#89E346', '#9375CC', '#A7E07E', '#663797', '#5677E8', '#E7BD3E', '#69EBE7', '#65C1B4', '#EAECEC', '#8133E9', '#D8E444', '#CDA7EA', '#E95A5C', '#E75592', '#D58A3F', '#DFB7B0', '#EB9AC4', '#73E8B5', '#B7EBC4', '#A561E9', '#A85C7E', '#DCE9A4', '#73A068', '#E045EF', '#99DAEF', '#C8AF72', '#58BBDA', '#5AE784', '#DBD769', '#E183DB'),
    c('#E0B9B2', '#E45B97', '#B4DB96', '#6181E7', '#5FE8CD', '#E9E754', '#D9C3E4', '#71A1DD', '#975EE0', '#EBE592', '#A4CEE3', '#5AEC94', '#94EDB6', '#DD9679', '#64BED6', '#B0EA7F', '#E64FEC', '#EA595B', '#6FE34A', '#86849D', '#6833E6', '#E2E9E8', '#71E5E8', '#E095BF', '#B46176', '#DE84E0', '#D33EB8', '#B333EF', '#C1A970', '#E2E1BB', '#53A53D', '#8059A5', '#B7E4CA', '#82957A', '#EBB93F', '#57B189', '#BCEC4C', '#D3883D', '#C9A3E5', '#B7BB44'),
    c('#BDA46F', '#987EA4', '#6294DB', '#D88A69', '#DA7EDE', '#59AE45', '#ACB9BD', '#E046EF', '#E0ACA6', '#9EBAE6', '#BEE8C5', '#E65593', '#E3EF54', '#E8D5E4', '#5CEC9A', '#56C199', '#5FEA71', '#D1EBEB', '#80D1EA', '#99AD8D', '#5E7F4A', '#E95A5C', '#84F0BF', '#985BE4', '#5F9EA9', '#81E537', '#E8C647', '#6AE6E1', '#726ACD', '#D644C0', '#E0B6DF', '#EAE394', '#8431EA', '#B5BF43', '#E790C5', '#E7DEBF', '#AD5C7D', '#C8A2EA', '#D99138', '#B5E296', '#AEEB76'),
    c('#E241D9', '#64EDB8', '#786BD0', '#7DBCE5', '#E1CFAE', '#E3E8E4', '#ECDF8E', '#E1E834', '#E95A5C', '#5ED2E1', '#9E5B7C', '#E8C544', '#9443EB', '#B19565', '#AA9ED1', '#A7D8EA', '#D06DD8', '#E497BA', '#6EE330', '#B5E9C7', '#B6BD42', '#D69033', '#E45A9D', '#61834A', '#5EBF95', '#ACEBA9', '#B6EC84', '#65BE4D', '#D999E3', '#62EADF', '#9EB39E', '#E39370', '#E9F272', '#E6EDBE', '#9FE8E2', '#5DED8A', '#DDC4E4', '#ACC27D', '#6391D8', '#DEB1AC', '#6E9DA5', '#A8E751'),
    c('#EDB83F', '#EBDE91', '#9BB8E4', '#6FAC3C', '#D33DB9', '#6CC5E4', '#DEC3E3', '#AB6486', '#E5E73B', '#AAA462', '#A4EB7F', '#DF4AED', '#E997D0', '#CBC547', '#E14B3E', '#8B43E9', '#B2E099', '#55E455', '#E56D7C', '#B8E7C8', '#6293DA', '#7175E8', '#D8A7AB', '#E75595', '#A2E443', '#D87CE0', '#EAEEEB', '#97997B', '#E2CAB8', '#C3A2E1', '#778A9C', '#59EB96', '#67BFBA', '#5CE8D3', '#D79048', '#DC9579', '#7D55A6', '#78E9ED', '#53A87A', '#85EBB7', '#E4E7BB', '#B1D7E0', '#DDF17C'),
    c('#CF32AE', '#E0ED55', '#E64B44', '#80B23C', '#DAB473', '#5BE986', '#E7E9EB', '#6164E3', '#E9547D', '#A1D4E9', '#757699', '#5B89E4', '#BAE3D2', '#9E9C73', '#6B27E7', '#7BA9E0', '#5BC1E0', '#DCC646', '#D78F35', '#E479DB', '#79A2A3', '#7A56A1', '#E2E394', '#E25EE7', '#B1E783', '#6CE4E6', '#DDB4AD', '#E837EA', '#DAC3E2', '#E4DFBC', '#E16EAB', '#9E57E2', '#DA856F', '#C0A6E3', '#85E541', '#B439EF', '#E198E1', '#80E8AB', '#E29ABE', '#62E6CA', '#BFEDBB', '#AB5F7C', '#64A87A', '#B07CE2'),
    c('#5BE37C', '#EA595A', '#DAD664', '#E45996', '#7F4E9C', '#DEC5E4', '#D63BB6', '#DCA237', '#739BA8', '#61C4C3', '#E2DEBE', '#777CC9', '#E1DE3B', '#74EDF0', '#579866', '#EB99C3', '#386FDF', '#B0EEBE', '#C1EAD8', '#9A7CEC', '#87D1EA', '#E03BEC', '#842CE9', '#EAEFAD', '#B86376', '#ADB46F', '#96B7E5', '#AEE264', '#63E5AB', '#AD8F6E', '#8E54E6', '#CCA6EA', '#65EAD1', '#ACE491', '#AF8DB2', '#E6C883', '#E28E62', '#D164E5', '#6B6F90', '#5999E0', '#DEE5E9', '#82E639', '#9BB89F', '#E185DC', '#E3B6AF'),
    c('#69B6D8', '#5EED9C', '#E035EB', '#DB7EDF', '#B0E496', '#8654DF', '#A3EEBF', '#DFB3AE', '#C1E6D3', '#82D9F0', '#E2B0D7', '#B2D3E0', '#D2C543', '#E579B6', '#5C8D3D', '#DFEB45', '#DB9D37', '#5AEACB', '#E3D8C0', '#D73AB5', '#81E537', '#5ADF69', '#757DEB', '#6EECEB', '#D4BB74', '#EB5080', '#6096DD', '#A6B580', '#D15FE7', '#E27F82', '#7F7A9E', '#B0688C', '#AEB7E8', '#852EEA', '#7D9795', '#E6EAB8', '#7F5BA9', '#EDED8E', '#5FBB90', '#65C4C1', '#D59FE7', '#B0E66E', '#E54C41', '#E9E0EC', '#E49161', '#AB8668'),
    c('#97DE94', '#5CEF79', '#6994A7', '#60C3C2', '#B19170', '#E8F071', '#EBCA67', '#C2A1E9', '#59BE95', '#EA595A', '#5CECD9', '#E1C1E3', '#D43FBC', '#84E637', '#57EB9A', '#6C74E7', '#DCE1C1', '#EEE7A9', '#7D55A5', '#C6E591', '#8B43E9', '#D87BE2', '#C16680', '#BBEDC0', '#75E9F0', '#ECEEEF', '#E2DD34', '#D5912E', '#B7E8D9', '#AFED77', '#E4AAA5', '#6393DB', '#ABBE3F', '#E95595', '#E39268', '#82F0BE', '#5ABA49', '#E492CD', '#E2C9BD', '#6DC8E8', '#9FB9E6', '#DF49EE', '#B6B370', '#94AC95', '#AFD5E2', '#A185A5', '#5F8449'),
    c('#D333B3', '#65B796', '#97819D', '#4A81B9', '#E8548F', '#D5B972', '#BDE095', '#E89BC0', '#D55DE6', '#EA5859', '#7DE439', '#E3DEBE', '#8DBAE5', '#5FEDE1', '#A7A17C', '#5BE984', '#78529F', '#709AEB', '#9AE38E', '#9AEFBE', '#66C7E4', '#E678DB', '#77DEE2', '#D18738', '#BDE7C9', '#4E71E3', '#B3DAE3', '#EAECEB', '#E2DD65', '#AE7BE4', '#B2A0DB', '#ECEDAA', '#5B814B', '#B76175', '#8028E7', '#DDC4E5', '#DE9273', '#E035EB', '#7AAC3B', '#E1B7B0', '#B6ED6F', '#E2A5EE', '#D177B8', '#EAB83C', '#789EA2', '#52E4AF', '#9155E8', '#D8DF32'),
    c('#6CEBE4', '#E7A09E', '#5E83DE', '#E9609A', '#BF9EEA', '#EAEFE7', '#B0DF99', '#E9B2DA', '#DDD4ED', '#65CFE2', '#6391A5', '#D53EBB', '#D48F30', '#F1CE78', '#A7E458', '#E33DED', '#DEBEB9', '#852FE9', '#8155A7', '#E95A5C', '#E89CE3', '#7467E7', '#B19170', '#90E331', '#59C4A0', '#B5DCD5', '#B65CE9', '#AC9DC5', '#B1BD44', '#A35869', '#B7709E', '#E3DDB9', '#5AE169', '#58E530', '#578E42', '#BCB575', '#86A58E', '#83F0BF', '#B2EB84', '#EAEFAB', '#5CEA97', '#9DCEE6', '#E2EC35', '#E39268', '#DD7ADD', '#6DA3DE', '#E3C63A', '#B9EAC6', '#E7F074'),
    c('#C3A4E8', '#5693D2', '#E3DD3D', '#DED662', '#E75CE9', '#B4CFD1', '#DC9939', '#DFD1B9', '#99D7EE', '#5BE66E', '#9AE9E8', '#B2DD97', '#61E6C4', '#E6EBBC', '#E6B2AE', '#5AA87B', '#5BC1C0', '#7783D2', '#59BDDE', '#B863DD', '#B5EB54', '#EA5491', '#9AB8E5', '#B7E5C6', '#5DECE9', '#D12FAF', '#D88766', '#EDDA91', '#7E4FDD', '#C76E8D', '#7A9592', '#80509C', '#93EDB4', '#E4B3DD', '#862FEC', '#967BEC', '#3E7CE9', '#E377D7', '#A8A969', '#72E22D', '#E1D0E6', '#76AB3A', '#DA37ED', '#EB5758', '#9F86A6', '#E291DA', '#B29474', '#EAF1EC', '#58EB98', '#B3EB83'),
    c('#A8E6D9', '#E5503D', '#D6E2C5', '#DCD1EA', '#AEBF7F', '#B29270', '#76E22F', '#63ECE0', '#EDECA5', '#DF8665', '#5DE870', '#E09BE4', '#BBEDC2', '#E35EA7', '#85EEBB', '#985AE6', '#E85376', '#618C9F', '#E2E533', '#5072E3', '#EAF0EE', '#8F2CEA', '#A3E783', '#57EC9A', '#E6B9E3', '#82A590', '#DAB773', '#EDE36D', '#7EBCE5', '#E044DD', '#E4C5BD', '#B5EB61', '#764D9B', '#5ABF95', '#E8A29E', '#AC87E2', '#A6627E', '#B0CBCE', '#B59DA8', '#99DAEE', '#6393DA', '#B7BD3C', '#D96ED5', '#E690BB', '#61824D', '#56A83D', '#DCA138', '#B0A1D6', '#BBE898', '#5BD0DD', '#EBDCB5'),
    c('#AFEB76', '#7BA29F', '#E08B64', '#5CEB92', '#ADE3C8', '#E33CEC', '#5EAF84', '#DCF1B3', '#EDD643', '#EDEC89', '#ACE091', '#D2902F', '#AE9372', '#4F81EB', '#8B5651', '#CEE6E8', '#BAA8E8', '#6DE1E4', '#EADDA9', '#B3B374', '#E4D9C1', '#E29DE7', '#7A6AB6', '#E7512D', '#59E7D2', '#E8A7A0', '#B177A7', '#988EAE', '#7ACDE7', '#D7ECCC', '#E3B6DD', '#BEBD42', '#BD5EE9', '#852FE9', '#90BAE5', '#793594', '#CFED49', '#69993C', '#B07CE2', '#BE6183', '#E95F68', '#DABCBB', '#F08EBC', '#D83CBD', '#6CDF48', '#E85091', '#5D93D5', '#735EE6', '#F1BD76', '#E278D8', '#E0D5EC', '#89EEBA'),
    c('#7BB039', '#81E537', '#DE6CAA', '#67ECE1', '#E45730', '#E84986', '#CE32AF', '#6AE7B7', '#E2B4B0', '#5DEB97', '#F0BD77', '#E295DF', '#B2E394', '#EBE59D', '#8565AF', '#E0C338', '#DFEB4B', '#E1D6C7', '#9CBAE7', '#D39031', '#DDCEA9', '#AF7BE6', '#B1D9E6', '#5178E9', '#B1ED79', '#4DA67B', '#A28CB0', '#6BD9E2', '#ECEFF1', '#BEEADA', '#6296A9', '#6194DB', '#7F28E7', '#C9A8EB', '#DFC5E5', '#AE6279', '#8DC0B4', '#E85F69', '#A7BC89', '#DE5DE6', '#A39859', '#E1EEC4', '#D98D6F', '#EC9EC3', '#62369D', '#5BE66E', '#E479DB', '#6FC7E7', '#9758ED', '#DDDB6B', '#AAEEBF', '#918C7D', '#DD34EB'),
    c('#DFA031', '#ECEEEF', '#E043D5', '#E9DBAA', '#9273CA', '#EA4F83', '#B1A3D9', '#92EFC0', '#9B5BE8', '#B0D9E8', '#DC8753', '#6FE22D', '#70DCEE', '#F195B5', '#5AEB96', '#B0587D', '#B4DDD2', '#6BEAE1', '#A27898', '#53B6BD', '#DC9EEA', '#7D3693', '#5F92D7', '#A7AD8F', '#A7E652', '#697E48', '#B5EE84', '#952CEB', '#EBB1DF', '#E0E7C9', '#7B989F', '#58B388', '#E64942', '#81BFE6', '#EBE388', '#A0E095', '#5BE66E', '#E2ADA6', '#5273E5', '#E7F470', '#DF7877', '#E5CCC0', '#DBC6E2', '#B6E8C4', '#E177BC', '#7AAC3B', '#D9C843', '#AC8567', '#E1EB34', '#B2C27F', '#DBF2B2', '#DD76DF', '#D9B06C', '#50E7B8'),
    c('#558F44', '#998DB0', '#B27DA5', '#E295E1', '#E3D2E9', '#8E2CE9', '#76E7EC', '#E4453F', '#D76AA4', '#4E71E3', '#9777D0', '#E8EBB3', '#E5879E', '#DC79DF', '#E54DED', '#EBBA3E', '#E3D9BD', '#EDF0EE', '#713E8F', '#66C7E5', '#81B9E4', '#7CE431', '#72DFAD', '#EDE987', '#D7BBBA', '#ABBC7A', '#ACBAE6', '#DDB9E3', '#E5EA43', '#9A5DE9', '#5CBBB1', '#B2E96A', '#4A82BB', '#6C8E94', '#C936B6', '#D7B974', '#C0EAD8', '#D28946', '#AED5E2', '#B6EEC0', '#975564', '#AB8F6E', '#EB507F', '#EEA5D2', '#E954B9', '#6E9CED', '#C5A5EB', '#BCC03F', '#5AE068', '#E87F73', '#5EEDDA', '#9BBAA0', '#5AEB97', '#E9ADA0', '#ACE591'),
    c('#B3EC80', '#E4AD3A', '#7B54A0', '#AED48C', '#4880B8', '#83D9F0', '#EE76AE', '#AC6FE5', '#DD30ED', '#C2EEBF', '#8129EA', '#64C399', '#ECECEC', '#6EB9E0', '#C36BAB', '#C1A7A8', '#DAE444', '#5FECCD', '#A059F0', '#CEADE5', '#A0B8E8', '#E99FE8', '#EA5678', '#DF3CA0', '#B86673', '#E69CC0', '#58EB98', '#5AAAB4', '#518B58', '#79AC3B', '#BDE4D1', '#DDD764', '#E2513C', '#E02CBE', '#6D9BEB', '#4FE1E4', '#87E63D', '#8AE8E1', '#94F0B5', '#5C40C4', '#DE9262', '#E1DCBA', '#EBB7AB', '#5BE66E', '#EF6FD4', '#DEC6E3', '#917FA1', '#EDE19A', '#AF8EE0', '#B2D3DF', '#5277E8', '#E085E8', '#B29F66', '#859685', '#E15DED', '#BA41B5'),
    c('#E0A49A', '#627842', '#BBE7C4', '#99EFBE', '#8BE9E4', '#5FE6D0', '#E95493', '#EFEDEF', '#7CAD3D', '#5AEC94', '#B49C64', '#B6D4DE', '#E3E3C4', '#8E5B53', '#57BCBE', '#E49268', '#DFC4E5', '#DDC0BD', '#C9A4E9', '#B07AE7', '#A389AD', '#E033EB', '#52BADD', '#88D9ED', '#98BFE2', '#862DEB', '#B2C580', '#EAEEAD', '#ADEB6D', '#73919B', '#C56B8F', '#4E71E3', '#E95A5C', '#E1CCA0', '#58B184', '#5BE66D', '#95AA91', '#ECCF75', '#7E59A4', '#D48F30', '#4780BA', '#94B2E9', '#DAC63B', '#E7EE70', '#9BE38D', '#D55EE9', '#56E7B1', '#76E22F', '#C5EFA1', '#8650DF', '#D439B6', '#E27EDB', '#C8EADD', '#EA99D1', '#4DEAF0', '#6E99EB', '#D5EC37'),
    c('#B29171', '#AABBBF', '#BFA4E7', '#92A88D', '#AEDAEB', '#98F0BC', '#D13BBA', '#DDF2AF', '#5DEC94', '#BFE4D8', '#CB70B0', '#E3CFBA', '#B0C17F', '#E7567E', '#E7DAA2', '#4EA6D3', '#E28870', '#BDF274', '#E0CFE7', '#80E435', '#9677D1', '#EDF0EF', '#E247EE', '#4F72E4', '#698996', '#E64B44', '#6F418F', '#5BECD9', '#A78CAF', '#4FAE7E', '#E2E8C7', '#6393DC', '#DBC540', '#B9E9C5', '#9BB9E6', '#DAB069', '#892DE9', '#DA8E33', '#A95F74', '#4FE9F1', '#EC95B9', '#78C8AE', '#81B53F', '#E3B8E2', '#56BCC3', '#995DE8', '#DD78E2', '#E49CE7', '#5BE66D', '#677B44', '#8BE8E7', '#54E5B2', '#E1E942', '#A8E38E', '#F063B6', '#E3B3AF', '#E9E57E', '#75D0EE'),
    c('#E955EA', '#58A33C', '#AED3DD', '#6116BC', '#D8F2B2', '#5BE66E', '#A9E58A', '#B4BF3F', '#E5AFF1', '#A24678', '#DFCAE8', '#EDE988', '#9E9777', '#D59031', '#EB656D', '#E5EA43', '#DB2BAF', '#61EBDB', '#DF4432', '#7611F5', '#6E8B99', '#EB5391', '#9FE9E5', '#8CBAE6', '#B2EBC7', '#5178E9', '#8263AF', '#E17E98', '#76E22F', '#E7CCC3', '#ED75DB', '#7AE6B2', '#AF6EE7', '#E7C542', '#5F93D9', '#57EC9A', '#61AC8A', '#AFA0D2', '#DC8BE6', '#B6EC65', '#7136F5', '#8D57ED', '#E8AD9D', '#59D7DE', '#B096EA', '#DC82C3', '#9C667D', '#D88665', '#C935F0', '#BB41B8', '#5F39A2', '#D5E2C6', '#E6DAAA', '#D9B36C', '#E4A5CC', '#C0A3AA', '#A5B875', '#EBF0EE', '#68C8E6'),
    c('#51B5D8', '#6AEFE7', '#83E639', '#D28064', '#66E5BF', '#639ADF', '#D4E3F0', '#E66E81', '#52E468', '#89569F', '#EDA5D2', '#7376C0', '#8C56ED', '#EAF1E7', '#9B7BEB', '#B7EDC8', '#C2F2AB', '#70EA89', '#417DE9', '#E4CEBC', '#C632EF', '#98BEEA', '#B19474', '#ECADA2', '#5BC6C3', '#ED4CE4', '#E198E8', '#3DEC9F', '#AFA057', '#E0C8E7', '#EACB85', '#D9E835', '#6B27E7', '#C7AAB1', '#AE6A89', '#7DE0F1', '#5B38A2', '#D970B2', '#B0D8CB', '#D88B3F', '#C7A6EB', '#CD31AD', '#EBEFA4', '#E74886', '#A6CA83', '#93C5D6', '#C360E3', '#E67ADE', '#EDB83D', '#58B184', '#AD9ECB', '#DFE3B9', '#7AB642', '#8EEEB0', '#7F9673', '#CAC442', '#B3EE7D', '#ECF074', '#6E7E8E', '#E64B44')
  )
  l[[k]]
}